/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.synapse.transport.amqp.AMQPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIParser {
    public static Map parse(String uri) {
        String[] params;
        HashMap<String, String> props = new HashMap<String, String>();
        String temp = uri.substring(6, uri.indexOf("?"));
        String exchangeType = temp.substring(0, temp.indexOf("/"));
        String exchangeName = temp.substring(temp.indexOf("/"), temp.length());
        if (exchangeType == null || exchangeType.trim().equals("")) {
            throw new IllegalArgumentException("exchange type cannot be null");
        }
        if (exchangeType == null || exchangeType.trim().equals("")) {
            throw new IllegalArgumentException("exchange name cannot be null");
        }
        props.put("transport.amqp.ExchangeName", exchangeName);
        props.put("transport.amqp.ExchangeType", exchangeType);
        String paramStr = uri.substring(uri.indexOf("?") + 1, uri.length());
        for (String param : params = paramStr.split("&amp;")) {
            String key = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1, param.length());
            if ("connectionURL".equals(key)) {
                key = "transport.amqp.ConnectionURL";
            }
            props.put(key, value);
        }
        return props;
    }

    public static String getEPR(List<AMQPBinding> list, String url) {
        String epr = null;
        for (AMQPBinding binding : list) {
            if (!binding.isPrimary()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("amqp:").append("/").append(binding.getExchangeType());
            sb.append("/").append(binding.getExchangeName());
            sb.append("?").append("routingKey").append("=").append(binding.getRoutingKey());
            sb.append("&amp;").append("connectionURL=").append(url);
            epr = sb.toString();
        }
        if (epr == null) {
            AMQPBinding binding = list.get(0);
            StringBuffer sb = new StringBuffer();
            sb.append("amqp:").append("/").append(binding.getExchangeType());
            sb.append("/").append(binding.getExchangeName());
            sb.append("?").append("routingKey").append("=").append(binding.getRoutingKey());
            sb.append("&amp;").append("connectionURL=").append(url);
            epr = sb.toString();
        }
        return epr;
    }

    public static void main(String[] args) {
        Map p = URIParser.parse("amqp:/direct?routing_key=SimpleStockQuoteService&amp;transport.amqp.ConnectionURL=qpid:virtualhost=test;client_id=foo@tcp:myhost.com:5672");
    }
}

