/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpidity.api.Message;
import org.apache.qpidity.nclient.Session;
import org.apache.qpidity.nclient.util.MessageListener;
import org.apache.qpidity.transport.RangeSet;
import org.apache.synapse.transport.amqp.AMQPSender;
import org.apache.synapse.transport.amqp.AMQPSynapseException;

public class MessageManager
implements MessageListener {
    private static final Log log = LogFactory.getLog(AMQPSender.class);
    private ArrayBlockingQueue<Message> queue = new ArrayBlockingQueue(1, true);
    private Session session;
    private String destination;
    private String corelationId;

    public MessageManager(Session session, String destination, String corelationId) {
        this.session = session;
        this.destination = destination;
    }

    public Message receive(long timeout) {
        Message m;
        this.session.messageFlow(this.destination, (short)0, 1L);
        this.session.messageFlow(this.destination, (short)1, -1L);
        try {
            m = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new AMQPSynapseException("unable to receive message", e);
        }
        if (m == null) {
            log.debug((Object)"Message Didn't arrive in time, checking if one is inflight");
            this.session.messageFlush(this.destination);
            this.session.sync();
            try {
                m = this.queue.take();
            }
            catch (Exception e) {
                throw new AMQPSynapseException("unable to receive message", e);
            }
        }
        return m;
    }

    public void onMessage(Message m) {
        System.out.println("\n================== Received Msg ==================");
        System.out.println("Message Id : " + m.getMessageProperties().getMessageId());
        System.out.println(m.toString());
        System.out.println("================== End Msg ==================\n");
        if (this.corelationId.equals(m.getMessageProperties().getCorrelationId())) {
            this.queue.add(m);
        } else {
            RangeSet r = new RangeSet();
            r.add(m.getMessageTransferId());
            this.session.messageRelease(r);
        }
    }
}

