/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpidity.api.Message;
import org.apache.synapse.transport.amqp.AMQPBinding;
import org.apache.synapse.transport.amqp.AMQPSynapseException;
import org.apache.synapse.transport.base.BaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQPUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(AMQPUtils.class);
    private static BaseUtils _instance = new AMQPUtils();

    public static BaseUtils getInstace() {
        return _instance;
    }

    @Override
    public InputStream getInputStream(Object message) {
        Message msg = (Message)message;
        try {
            final ByteBuffer buf = msg.readData();
            return new InputStream(){

                public synchronized int read() throws IOException {
                    if (!buf.hasRemaining()) {
                        return -1;
                    }
                    return buf.get();
                }

                public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                    len = Math.min(len, buf.remaining());
                    buf.get(bytes, off, len);
                    return len;
                }
            };
        }
        catch (IOException e) {
            throw new AMQPSynapseException("Error reading payload", e);
        }
    }

    @Override
    public byte[] getMessageBinaryPayload(Object message) {
        return null;
    }

    @Override
    public String getMessageTextPayload(Object message) {
        return null;
    }

    @Override
    public String getProperty(Object message, String property) {
        try {
            return (String)((Message)message).getMessageProperties().getApplicationHeaders().get(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map getTransportHeaders(Message message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (message.getMessageProperties().getCorrelationId() != null) {
            map.put("AMQP_CORELATION_ID", message.getMessageProperties().getCorrelationId());
        }
        try {
            map.put("AMQP_DELIVERY_MODE", message.getDeliveryProperties().getDeliveryMode());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        map.put("AMQP_EXCHANGE_NAME", message.getDeliveryProperties().getExchange());
        map.put("AMQP_ROUTING_KEY", message.getDeliveryProperties().getRoutingKey());
        try {
            map.put("AMQP_EXPIRATION", message.getDeliveryProperties().getExpiration());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message.getMessageProperties().getMessageId() != null) {
            map.put("AMQP_MESSAGE_ID", message.getMessageProperties().getMessageId());
        }
        map.put("AMQP_PRIORITY", message.getDeliveryProperties().getPriority());
        map.put("AMQP_REDELIVERED", message.getDeliveryProperties().getRedelivered());
        if (message.getMessageProperties().getReplyTo() != null) {
            map.put("AMQP_REPLY_TO_EXCHANGE_NAME", message.getMessageProperties().getReplyTo().getExchangeName());
            map.put("AMQP_REPLY_TO_ROUTING_KEY", message.getMessageProperties().getReplyTo().getRoutingKey());
        }
        map.put("AMQP_TIMESTAMP", message.getDeliveryProperties().getTimestamp());
        map.putAll(message.getMessageProperties().getApplicationHeaders());
        return map;
    }

    public static List<AMQPBinding> getBindingsForService(AxisService service) {
        Parameter bindingsParam = service.getParameter("transport.amqp.Bindings");
        ParameterIncludeImpl pi = new ParameterIncludeImpl();
        try {
            pi.deserializeParameters((OMElement)bindingsParam.getValue());
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error reading parameters for AMQP binding definitions" + bindingsParam.getName()), (Throwable)axisFault);
        }
        Iterator params = pi.getParameters().iterator();
        ArrayList<AMQPBinding> list = new ArrayList<AMQPBinding>();
        if (params.hasNext()) {
            while (params.hasNext()) {
                Parameter p = (Parameter)params.next();
                AMQPBinding binding = new AMQPBinding();
                OMAttribute exchangeTypeAttr = p.getParameterElement().getAttribute(new QName("exchangeType"));
                OMAttribute exchangeNameAttr = p.getParameterElement().getAttribute(new QName("exchangeName"));
                OMAttribute routingKeyAttr = p.getParameterElement().getAttribute(new QName("routingKey"));
                OMAttribute primaryAttr = p.getParameterElement().getAttribute(new QName("primary"));
                if (exchangeTypeAttr != null) {
                    binding.setExchangeType(exchangeTypeAttr.getAttributeValue());
                } else if (exchangeNameAttr != null) {
                    binding.setExchangeName(exchangeNameAttr.getAttributeValue());
                } else if (primaryAttr != null) {
                    binding.setPrimary(true);
                }
                list.add(binding);
            }
        } else {
            AMQPBinding binding = new AMQPBinding();
            binding.setRoutingKey(service.getName());
            list.add(binding);
        }
        return list;
    }
}

