/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpidity.api.Message;
import org.apache.qpidity.nclient.Client;
import org.apache.qpidity.nclient.Connection;
import org.apache.qpidity.nclient.MessagePartListener;
import org.apache.qpidity.nclient.Session;
import org.apache.qpidity.nclient.util.MessageListener;
import org.apache.qpidity.nclient.util.MessagePartListenerAdapter;
import org.apache.qpidity.transport.DeliveryProperties;
import org.apache.qpidity.transport.MessageProperties;
import org.apache.qpidity.transport.Option;
import org.apache.qpidity.transport.ReplyTo;
import org.apache.qpidity.transport.Struct;
import org.apache.synapse.transport.amqp.AMQPOutTransportInfo;
import org.apache.synapse.transport.amqp.AMQPSynapseException;
import org.apache.synapse.transport.amqp.AMQPUtils;
import org.apache.synapse.transport.amqp.MessageManager;
import org.apache.synapse.transport.base.AbstractTransportSender;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.jms.JMSUtils;

public class AMQPSender
extends AbstractTransportSender {
    public static final String TRANSPORT_NAME = "amqp";
    private static final Log log = LogFactory.getLog(AMQPSender.class);
    private Map<String, ConnectionDetails> _connectionDetails = new HashMap<String, ConnectionDetails>();

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, transportOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        AMQPOutTransportInfo amqpTransportInfo = null;
        ConnectionDetails conDetails = null;
        Session session = null;
        if (targetEPR != null) {
            amqpTransportInfo = new AMQPOutTransportInfo(targetEPR);
        } else if (outTransportInfo != null && outTransportInfo instanceof AMQPOutTransportInfo) {
            amqpTransportInfo = (AMQPOutTransportInfo)outTransportInfo;
        }
        if (this._connectionDetails.containsKey(amqpTransportInfo.getConnectionURL())) {
            conDetails = this._connectionDetails.get(amqpTransportInfo.getConnectionURL());
        } else {
            Connection con = Client.createConnection();
            try {
                con.connect(amqpTransportInfo.getConnectionURL());
            }
            catch (Exception e) {
                throw new AMQPSynapseException("Error creating a connection to the broker", e);
            }
            this._connectionDetails.put(amqpTransportInfo.getConnectionURL(), new ConnectionDetails(con));
        }
        if (conDetails != null) {
            session = conDetails.getSession();
        }
        byte[] message = null;
        try {
            message = this.createMessageData(msgCtx);
        }
        catch (AMQPSynapseException e) {
            this.handleException("Error creating a message from the axis message context", e);
        }
        boolean waitForResponse = this.waitForSynchronousResponse(msgCtx);
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties msgProps = new MessageProperties();
        this.fillMessageHeaders(msgCtx, amqpTransportInfo, session, waitForResponse, deliveryProps, msgProps);
        Session session2 = session;
        synchronized (session2) {
            session.header(new Struct[]{msgProps, deliveryProps});
            session.data(message);
            session.endData();
        }
        if (waitForResponse) {
            this.waitForResponseAndProcess(session, msgProps, msgCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMessageHeaders(MessageContext msgCtx, AMQPOutTransportInfo amqpTransportInfo, Session session, boolean waitForResponse, DeliveryProperties deliveryProps, MessageProperties msgProps) {
        deliveryProps.setExchange(amqpTransportInfo.getExchangeName());
        deliveryProps.setRoutingKey(amqpTransportInfo.getRoutingKey());
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgCtx);
        MessageFormatter messageFormatter = null;
        try {
            messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgCtx);
        }
        catch (AxisFault axisFault) {
            throw new AMQPSynapseException("Unable to get the message formatter to use");
        }
        String contentType = messageFormatter.getContentType(msgCtx, format, msgCtx.getSoapAction());
        msgProps.setContentType(contentType);
        HashMap<String, String> props = new HashMap<String, String>();
        if (msgCtx.isServerSide()) {
            props.put("SOAPAction", (String)msgCtx.getProperty("SOAPAction"));
        } else {
            String action = msgCtx.getOptions().getAction();
            if (action != null) {
                props.put("SOAPAction", action);
            }
        }
        msgProps.setApplicationHeaders(props);
        Map headerMap = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (headerMap != null) {
            for (String name : headerMap.keySet()) {
                if ("AMQP_CORELATION_ID".equals(name)) {
                    msgProps.setCorrelationId((String)headerMap.get("AMQP_CORELATION_ID"));
                    continue;
                }
                if ("AMQP_DELIVERY_MODE".equals(name)) {
                    Object o = headerMap.get("AMQP_DELIVERY_MODE");
                    if (o instanceof Short) {
                        deliveryProps.setDeliveryMode(((Short)o).shortValue());
                        continue;
                    }
                    if (o instanceof Integer) {
                        deliveryProps.setDeliveryMode(((Integer)o).shortValue());
                        continue;
                    }
                    if (o instanceof String) {
                        try {
                            deliveryProps.setDeliveryMode(Short.parseShort((String)o));
                        }
                        catch (NumberFormatException nfe) {
                            log.warn((Object)("Invalid delivery mode ignored : " + o), (Throwable)nfe);
                        }
                        continue;
                    }
                    log.warn((Object)("Invalid delivery mode ignored : " + o));
                    continue;
                }
                if ("AMQP_EXPIRATION".equals(name)) {
                    deliveryProps.setExpiration(Long.parseLong((String)headerMap.get("AMQP_EXPIRATION")));
                    continue;
                }
                if ("AMQP_MESSAGE_ID".equals(name)) {
                    msgProps.setMessageId((String)headerMap.get("AMQP_MESSAGE_ID"));
                    continue;
                }
                if ("AMQP_PRIORITY".equals(name)) {
                    deliveryProps.setPriority(Short.parseShort((String)headerMap.get("AMQP_PRIORITY")));
                    continue;
                }
                if ("AMQP_TIMESTAMP".equals(name)) {
                    deliveryProps.setTimestamp(Long.parseLong((String)headerMap.get("AMQP_TIMESTAMP")));
                    continue;
                }
                Object value = headerMap.get(name);
                props.put(name, (String)value);
            }
        }
        if (msgCtx.getProperty("AMQP_REPLY_TO_EXCHANGE_NAME") != null) {
            String replyExchangeName = (String)msgCtx.getProperty("AMQP_REPLY_TO_EXCHANGE_NAME");
            String replyRoutingKey = msgCtx.getProperty("AMQP_REPLY_TO_ROUTING_KEY") != null ? (String)msgCtx.getProperty("AMQP_REPLY_TO_ROUTING_KEY") : null;
            msgProps.setReplyTo(new ReplyTo(replyExchangeName, replyRoutingKey));
        }
        if (waitForResponse) {
            if (waitForResponse && msgProps.getCorrelationId() == null) {
                if (msgCtx.getProperty("AMQP_CORELATION_ID") != null) {
                    msgProps.setCorrelationId((String)msgCtx.getProperty("AMQP_CORELATION_ID"));
                } else {
                    msgProps.setCorrelationId(UUIDGenerator.getUUID());
                }
            }
            if (msgProps.getReplyTo() == null) {
                String tempQueueName = "Queue_" + msgProps.getCorrelationId();
                Session session2 = session;
                synchronized (session2) {
                    session.queueDeclare(tempQueueName, null, null, new Option[]{Option.AUTO_DELETE, Option.EXCLUSIVE});
                    session.queueBind(tempQueueName, "amq.direct", tempQueueName, null);
                    session.sync();
                }
                msgProps.replyTo(new ReplyTo("amq.direct", tempQueueName));
            }
        }
    }

    private byte[] createMessageData(MessageContext msgContext) {
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = null;
        try {
            messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        }
        catch (AxisFault axisFault) {
            throw new AMQPSynapseException("Unable to get the message formatter to use", (Exception)((Object)axisFault));
        }
        String contentType = messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            messageFormatter.writeTo(msgContext, format, (OutputStream)baos, true);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AMQPSynapseException("IO Error while creating message", e);
        }
    }

    private void waitForResponseAndProcess(Session session, MessageProperties msgProps, MessageContext msgCtx) throws AxisFault {
        long timeout = 30000L;
        String waitReply = (String)msgCtx.getProperty("AMQP_WAIT_REPLY");
        if (waitReply != null) {
            timeout = Long.valueOf(waitReply);
        }
        String destination = msgProps.getReplyTo().getRoutingKey();
        MessageManager listener = new MessageManager(session, destination, msgProps.getCorrelationId());
        session.messageSubscribe(msgProps.getReplyTo().getRoutingKey(), destination, (short)1, (short)0, (MessagePartListener)new MessagePartListenerAdapter((MessageListener)listener), null, new Option[]{Option.NO_OPTION});
        Message reply = listener.receive(timeout);
        if (reply != null) {
            this.processSyncResponse(msgCtx, reply);
        } else {
            log.warn((Object)("Did not receive a response within " + timeout + " ms to destination : " + msgProps.getReplyTo().getRoutingKey() + " with correlation ID : " + msgProps.getCorrelationId()));
        }
    }

    private void processSyncResponse(MessageContext outMsgCtx, Message message) throws AxisFault {
        MessageContext responseMsgCtx = this.createResponseMessageContext(outMsgCtx);
        Map map = AMQPUtils.getTransportHeaders(message);
        responseMsgCtx.setProperty("TRANSPORT_HEADERS", (Object)map);
        responseMsgCtx.setServerSide(false);
        String contentType = JMSUtils.getInstace().getProperty(message, "Content-Type");
        AMQPUtils.getInstace().setSOAPEnvelope(message, responseMsgCtx, contentType);
        responseMsgCtx.setServerSide(true);
        this.handleIncomingMessage(responseMsgCtx, map, (String)map.get("SOAPAction"), contentType);
    }

    private class ConnectionDetails {
        private Connection _conn;
        private Session _session;

        public ConnectionDetails(Connection conn) {
            this._conn = conn;
        }

        public Session getSession() {
            if (this._session != null) {
                this._session = this._conn.createSession(0L);
            }
            return this._session;
        }
    }
}

