/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.Map;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPSynapseException;
import org.apache.synapse.transport.amqp.URIParser;

public class AMQPOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(OutTransportInfo.class);
    private String address = null;
    private String contentType = null;
    private String conURL = null;
    private String exchangeName = null;
    private String routingKey = null;

    public AMQPOutTransportInfo(String address) {
        this.address = address;
        if (!address.startsWith("amqp:")) {
            this.handleException("Invalid prefix for a AMQP EPR : " + address);
        } else {
            Map props = URIParser.parse(address);
            this.conURL = (String)props.get("transport.amqp.ConnectionURL");
            this.routingKey = (String)props.get("routingKey");
            this.exchangeName = (String)props.get("transport.amqp.ExchangeName");
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getConnectionURL() {
        return this.conURL;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AMQPSynapseException(s, e);
    }

    private void handleException(String s) {
        log.error((Object)s);
        throw new AMQPSynapseException(s);
    }
}

