/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPBinding;
import org.apache.synapse.transport.amqp.AMQPConnection;
import org.apache.synapse.transport.amqp.AMQPSynapseException;
import org.apache.synapse.transport.amqp.AMQPUtils;
import org.apache.synapse.transport.amqp.URIParser;
import org.apache.synapse.transport.base.AbstractTransportListener;
import org.apache.synapse.transport.base.BaseUtils;

public class AMQPListener
extends AbstractTransportListener {
    public static final String TRANSPORT_NAME = "AMQP";
    private static final Log log = LogFactory.getLog(AMQPListener.class);
    private Map<String, AMQPConnection> connections = new HashMap<String, AMQPConnection>();
    private Map serviceNameToEPRMap = new HashMap();

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, transportIn);
        this.loadConnectionDefinitions(transportIn);
        if (this.connections.isEmpty()) {
            log.warn((Object)"No AMQP connections are defined. Cannot listen on AMQP");
            return;
        }
        log.info((Object)"AMQP Transport Receiver/Listener initialized...");
    }

    public void start() throws AxisFault {
        for (String conName : this.connections.keySet()) {
            AMQPConnection conDef = this.connections.get(conName);
            conDef.start();
        }
        super.start();
    }

    public void stop() throws AxisFault {
        for (String conName : this.connections.keySet()) {
            AMQPConnection connection = this.connections.get(conName);
            try {
                connection.stop();
            }
            catch (Exception e) {
                throw new AMQPSynapseException("Error creating a connection to the broker", e);
            }
        }
        super.stop();
    }

    protected void startListeningForService(AxisService service) {
        if (service.getName().startsWith("__")) {
            return;
        }
        AMQPConnection con = this.getConnectionFactory(service);
        if (con == null) {
            String msg = "Service " + service.getName() + " does not specify" + "an AMQP connection or refers to an invalid connection. " + "This service is being marked as faulty and will not be " + "available over the AMQP transport";
            log.warn((Object)msg);
            BaseUtils.markServiceAsFaulty(service.getName(), msg, service.getAxisConfiguration());
            return;
        }
        List<AMQPBinding> bindings = AMQPUtils.getBindingsForService(service);
        this.serviceNameToEPRMap.put(service.getName(), URIParser.getEPR(bindings, con.getUrl()));
        log.info((Object)("Starting to listen for service " + service.getName()));
    }

    protected void stopListeningForService(AxisService service) {
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (serviceName.indexOf(47) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        return new EndpointReference[]{new EndpointReference((String)this.serviceNameToEPRMap.get(serviceName))};
    }

    private void loadConnectionDefinitions(TransportInDescription transprtIn) {
        for (Parameter conParams : transprtIn.getParameters()) {
            ParameterIncludeImpl pi = new ParameterIncludeImpl();
            AMQPConnection conDef = new AMQPConnection();
            try {
                pi.deserializeParameters((OMElement)conParams.getValue());
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error reading parameters for AMQP Connection definitions" + conParams.getName()), (Throwable)axisFault);
            }
            conDef.setName((String)conParams.getValue());
            for (Parameter p : pi.getParameters()) {
                if ("transport.amqp.ConnectionURL".equals(p.getName())) {
                    conDef.setUrl((String)p.getValue());
                    continue;
                }
                if ("transport.amqp.ExchangeName".equals(p.getName())) {
                    conDef.setExchangeName((String)p.getValue());
                    continue;
                }
                if (!"transport.amqp.ExchangeType".equals(p.getName())) continue;
                conDef.setExchangeType((String)p.getValue());
            }
            this.connections.put(conDef.getName(), conDef);
        }
    }

    private AMQPConnection getConnectionFactory(AxisService service) {
        Parameter conNameParam = service.getParameter("transport.amqp.ConnectionName");
        Parameter conURLParam = service.getParameter("transport.amqp.ConnectionURL");
        if (conNameParam != null) {
            String conFac = (String)conNameParam.getValue();
            if (this.connections.containsKey(conFac)) {
                return this.connections.get(conFac);
            }
            return null;
        }
        if (conURLParam != null) {
            AMQPConnection con = new AMQPConnection();
            con.setUrl((String)conURLParam.getValue());
            con.start();
            this.connections.put(service.getName(), con);
            return con;
        }
        if (this.connections.containsKey("default")) {
            return this.connections.get("default");
        }
        return null;
    }
}

