/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpidity.ErrorCode;
import org.apache.qpidity.nclient.Client;
import org.apache.qpidity.nclient.ClosedListener;
import org.apache.qpidity.nclient.Connection;
import org.apache.synapse.transport.amqp.AMQPSynapseException;

class AMQPConnection
implements ClosedListener {
    private static final Log log = LogFactory.getLog(AMQPConnection.class);
    private String name;
    private String url;
    private Connection con;
    private String exchangeName = "amq.direct";
    private String exchangeType = "direct";
    private long reconnectTimeout = 30000L;

    public AMQPConnection() {
    }

    public AMQPConnection(String name, String url, String exchangeName, String exchangeType) {
        this.name = name;
        this.url = url;
        this.exchangeName = exchangeName;
        this.exchangeType = exchangeType;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Connection getConnection() {
        return this.con;
    }

    public void setConnection(Connection con) {
        this.con = con;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public void stop() {
    }

    public void start() throws AMQPSynapseException {
        Connection con = Client.createConnection();
        try {
            con.connect(this.url);
        }
        catch (Exception e) {
            throw new AMQPSynapseException("Error creating a connection to the broker", e);
        }
    }

    public void onClosed(ErrorCode errorCode, String reason) {
        log.error((Object)("AMQP connection " + this.name + " encountered an error, Error code:" + errorCode + " reason:" + reason));
        boolean wasError = true;
        while (wasError) {
            try {
                wasError = false;
            }
            catch (Exception e1) {
                log.warn((Object)("AMQP reconnection attempt failed for connection : " + this.name), (Throwable)e1);
            }
            if (!wasError) continue;
            try {
                log.info((Object)("Attempting reconnection for connection " + this.name + " in " + this.getReconnectTimeout() / 1000L + " seconds"));
                Thread.sleep(this.getReconnectTimeout());
            }
            catch (InterruptedException ignore) {}
        }
    }
}

