/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.io.IOUtils;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseUtils;

public class PlainTextBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        String textPayload;
        Parameter wrapperParam;
        QName wrapperQName = BaseConstants.DEFAULT_TEXT_WRAPPER;
        if (msgContext.getAxisService() != null && (wrapperParam = msgContext.getAxisService().getParameter("Wrapper")) != null) {
            wrapperQName = BaseUtils.getQNameFromString(wrapperParam.getValue());
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement wrapper = factory.createOMElement(wrapperQName, null);
        String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
        try {
            textPayload = IOUtils.toString((InputStream)inputStream, (String)charSetEnc);
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to read message payload", (Throwable)ex);
        }
        wrapper.addChild((OMNode)factory.createOMText(textPayload));
        return wrapper;
    }
}

