/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TokenValidator;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Element;

public class SAMLTokenValidator
implements TokenValidator {
    Log log = LogFactory.getLog((Class)SAMLTokenValidator.class);
    private String configFile;
    private OMElement configElement;
    private String configParamName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPEnvelope validate(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        TokenStorage tkStorage = TrustUtil.getTokenStore(inMsgCtx);
        try {
            OMElement rstrElem;
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
            int wstVersion = data.getVersion();
            if (1 == wstVersion) {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            } else {
                OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
            }
            TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText(TrustUtil.getWSTNamespace(wstVersion) + "/RSTR/Status");
            OMElement statusElement = SAMLTokenValidator.createMessageElement(wstVersion, rstrElem, "Status");
            Token tk = tkStorage.getToken(data.getTokenId());
            PublicKey issuerPBKey = this.getIssuerPublicKey(inMsgCtx);
            boolean valid = this.isValid(tk, issuerPBKey);
            String validityCode = valid ? "/status/valid" : "/status/invalid";
            SAMLTokenValidator.createMessageElement(wstVersion, statusElement, "Code").setText(TrustUtil.getWSTNamespace(wstVersion) + validityCode);
            SOAPEnvelope sOAPEnvelope = env;
            return sOAPEnvelope;
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
    }

    private boolean isValid(Token token, PublicKey issuerPBKey) {
        OMElement assertionOMElement = token.getToken();
        SAMLAssertion samlAssertion = null;
        try {
            samlAssertion = new SAMLAssertion((Element)assertionOMElement);
            this.log.info((Object)"Verifying token validity...");
            samlAssertion.verify((Key)issuerPBKey);
        }
        catch (SAMLException e) {
            this.log.error((Object)"Could not verify signature", (Throwable)e);
            return false;
        }
        return true;
    }

    private PublicKey getIssuerPublicKey(MessageContext inMsgCtx) {
        PublicKey issuerPBKey = null;
        SAMLTokenIssuerConfig config = null;
        try {
            if (this.configElement != null) {
                config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            }
            if (config == null && this.configFile != null) {
                config = new SAMLTokenIssuerConfig(this.configFile);
            }
            if (config == null && this.configParamName != null) {
                Parameter param = inMsgCtx.getParameter(this.configParamName);
                if (param != null && param.getParameterElement() != null) {
                    config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
                } else {
                    throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
                }
            }
            if (config == null) {
                throw new TrustException("configurationIsNull");
            }
            Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
            X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            issuerPBKey = issuerCerts[0].getPublicKey();
        }
        catch (Exception e) {
            this.log.error((Object)"Could not retrieve issuer public key", (Throwable)e);
        }
        return issuerPBKey;
    }

    private static OMElement createMessageElement(int version, OMElement parent, String elementName) throws TrustException {
        return SAMLTokenValidator.createOMElement(parent, TrustUtil.getWSTNamespace(version), elementName, "wst");
    }

    private static OMElement createOMElement(OMElement parent, String ns, String ln, String prefix) {
        return parent.getOMFactory().createOMElement(new QName(ns, ln, prefix), (OMContainer)parent);
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }
}

