/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.ws.security.message.token.Reference;

public class SimpleTokenStore
implements TokenStorage {
    protected Map tokens = new Hashtable();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Token token) throws TrustException {
        block5: {
            if (token != null && !"".equals(token.getId()) && token.getId() != null) {
                this.writeLock.lock();
                try {
                    if (this.tokens.keySet().size() == 0 || this.tokens.keySet().size() > 0 && !this.tokens.keySet().contains(token.getId())) {
                        this.tokens.put(token.getId(), token);
                        break block5;
                    }
                    throw new TrustException("tokenAlreadyExists", new String[]{token.getId()});
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Token token) throws TrustException {
        if (token != null && token.getId() != null && token.getId().trim().length() != 0) {
            this.writeLock.lock();
            try {
                if (!this.tokens.keySet().contains(token.getId())) {
                    throw new TrustException("noTokenToUpdate", new String[]{token.getId()});
                }
                this.tokens.put(token.getId(), token);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTokenIdentifiers() throws TrustException {
        ArrayList identifiers = new ArrayList();
        this.readLock.lock();
        try {
            Iterator iterator = this.tokens.keySet().iterator();
            while (iterator.hasNext()) {
                identifiers.add(iterator.next());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return identifiers.toArray(new String[identifiers.size()]);
    }

    public Token[] getValidTokens() throws TrustException {
        return this.getTokens(new int[]{1, 4});
    }

    public Token[] getRenewedTokens() throws TrustException {
        return this.getTokens(4);
    }

    public Token[] getCancelledTokens() throws TrustException {
        return this.getTokens(3);
    }

    public Token[] getExpiredTokens() throws TrustException {
        return this.getTokens(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token[] getTokens(int[] states) throws TrustException {
        this.processTokenExpiry();
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.readLock.lock();
        try {
            Iterator iterator = this.tokens.values().iterator();
            block3: while (iterator.hasNext()) {
                Token token = (Token)iterator.next();
                for (int i = 0; i < states.length; ++i) {
                    if (token.getState() != states[i]) continue;
                    tokens.add(token);
                    continue block3;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token[] getTokens(int state) throws TrustException {
        this.processTokenExpiry();
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.readLock.lock();
        try {
            Iterator iterator = this.tokens.values().iterator();
            while (iterator.hasNext()) {
                Token token = (Token)iterator.next();
                if (token.getState() != state) continue;
                tokens.add(token);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(String id) throws TrustException {
        Token token;
        this.processTokenExpiry();
        this.readLock.lock();
        try {
            token = (Token)this.tokens.get(id);
            if (token == null) {
                Iterator iterator = this.tokens.values().iterator();
                while (iterator.hasNext()) {
                    Token tempToken = (Token)iterator.next();
                    OMElement elem = tempToken.getAttachedReference();
                    if (elem != null) {
                        if (id.equals(SimpleTokenStore.getIdFromSTR(elem))) {
                            token = tempToken;
                        }
                    }
                    if ((elem = tempToken.getUnattachedReference()) == null) continue;
                    if (!id.equals(SimpleTokenStore.getIdFromSTR(elem))) continue;
                    token = tempToken;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTokenExpiry() throws TrustException {
        this.readLock.lock();
        try {
            Iterator iterator = this.tokens.values().iterator();
            while (iterator.hasNext()) {
                Token token = (Token)iterator.next();
                if (token.getExpires() == null || token.getExpires().getTime() >= System.currentTimeMillis()) continue;
                token.setState(2);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static String getIdFromSTR(OMElement str) {
        OMElement child = str.getFirstElement();
        if (child == null) {
            return null;
        }
        if (child.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"))) {
            return child.getText();
        }
        if (child.getQName().equals(Reference.TOKEN)) {
            return child.getAttributeValue(new QName("URI")).substring(1);
        }
        return null;
    }
}

