/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.truezip;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractLayeredFileProvider;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.local.LocalFileName;
import org.apache.commons.vfs.provider.local.LocalFileNameParser;
import org.apache.commons.vfs.provider.truezip.TzFileSystem;

public class TzFileProvider
extends AbstractLayeredFileProvider {
    public static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT));

    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = new LayeredFileName(scheme, file.getName(), "/", FileType.FOLDER);
        return new TzFileSystem((FileName)name, file, fileSystemOptions);
    }

    public boolean isAbsoluteLocalName(String name) {
        return ((LocalFileNameParser)this.getFileNameParser()).isAbsoluteName(name);
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LocalFileName rootName = (LocalFileName)name;
        return new TzFileSystem((FileName)rootName, rootName.getRootFile(), fileSystemOptions);
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

