/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMNodeList
implements NodeList {
    private List sequence;

    public DOMNodeList(List list) {
        this.sequence = list;
    }

    public static DOMNodeList checkAndMake(SequenceExtent sequenceExtent) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = sequenceExtent.iterate();
        ArrayList<Item> arrayList = new ArrayList<Item>(sequenceExtent.getLength());
        while ((item = sequenceIterator.next()) != null) {
            Object object = item;
            if (!(object instanceof NodeInfo)) {
                throw new DynamicError("Supplied sequence contains an item that is not a Saxon NodeInfo");
            }
            if (!(object instanceof VirtualNode)) continue;
            if (!((object = ((VirtualNode)object).getUnderlyingNode()) instanceof Node)) {
                throw new DynamicError("Supplied sequence contains an item that is not a wrapper around a DOM Node");
            }
            arrayList.add((Item)object);
        }
        return new DOMNodeList(arrayList);
    }

    public int getLength() {
        return this.sequence.size();
    }

    public Node item(int n) {
        return (Node)this.sequence.get(n);
    }
}

