/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.workers;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.state.RMDContext;
import org.wso2.mercury.state.RMSContext;

public class SequenceRemovalWorker
implements Runnable {
    private static Log log = LogFactory.getLog(SequenceRemovalWorker.class);
    private ConfigurationContext configContext;
    private boolean isShutDown = false;
    private long sequenceRemovalWorkerSleepTime;

    public SequenceRemovalWorker(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public void run() {
        this.removeSequences();
    }

    private synchronized void removeSequences() {
        while (!this.isShutDown) {
            RMSContext rmsContext = (RMSContext)this.configContext.getProperty("MercuryRMSContext");
            RMDContext rmdContext = (RMDContext)this.configContext.getProperty("MercuryRMDContext");
            rmsContext.removeExpiredSequences();
            rmdContext.removeExpiredSequences();
            try {
                this.wait(this.sequenceRemovalWorkerSleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)"Shutting down the Sequence removal worker");
    }

    public synchronized void shutDownWorker() {
        this.isShutDown = true;
        this.notify();
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    public void setShutDown(boolean shutDown) {
        this.isShutDown = shutDown;
    }

    public long getSequenceRemovalWorkerSleepTime() {
        return this.sequenceRemovalWorkerSleepTime;
    }

    public void setSequenceRemovalWorkerSleepTime(long sequenceRemovalWorkerSleepTime) {
        this.sequenceRemovalWorkerSleepTime = sequenceRemovalWorkerSleepTime;
    }
}

