/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.workers;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.state.RMSSequence;

public class RMSSequenceWorker
implements Runnable {
    private static Log log = LogFactory.getLog(RMSSequenceWorker.class);
    private long sequenceWorkerSleepTime;
    private RMSSequence rmsSequence;
    private Object lock = new Object();

    public RMSSequenceWorker(RMSSequence rmsSequence) {
        this.rmsSequence = rmsSequence;
        this.rmsSequence.setRMSSequenceWorker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.rmsSequence.getState() != 7 && System.currentTimeMillis() - this.rmsSequence.getLastAccessedTime() < this.rmsSequence.getTimeoutTime()) {
            try {
                this.rmsSequence.doActions();
            }
            catch (AxisFault e) {
                log.error((Object)("Fault occured when doing actions for the RMS Sequence " + this.rmsSequence.getSequenceID()), (Throwable)e);
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)"Could not build the message ", (Throwable)e);
            }
            try {
                log.debug((Object)"Wait");
                Object e = this.lock;
                synchronized (e) {
                    this.lock.wait(this.sequenceWorkerSleepTime);
                }
                log.debug((Object)"Wakeup...");
            }
            catch (InterruptedException e) {
                log.error((Object)("Interupted :" + e));
            }
        }
        try {
            if (this.rmsSequence.getState() == 7) {
                this.rmsSequence.sendTerminateSequenceMessage(null);
            } else if (this.rmsSequence.isAnnonymous()) {
                this.rmsSequence.rmsSequenceExpired();
            } else {
                this.rmsSequence.sendTerminateSequenceMessage(null);
            }
        }
        catch (AxisFault e) {
            log.error((Object)("Fault occured when doing actions for the RMS Sequence " + this.rmsSequence.getSequenceID()), (Throwable)e);
        }
        catch (RMMessageBuildingException e) {
            log.error((Object)"Could not build the message ", (Throwable)e);
        }
        log.info((Object)("Stopping the RMS thread for RMS sequence " + this.rmsSequence.getSequenceID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        try {
            log.debug((Object)"WakeUp");
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            log.debug((Object)"Thread notified");
        }
        catch (Exception e) {
            log.error((Object)("Failed to notify : " + e), (Throwable)e);
        }
    }

    public long getSequenceWorkerSleepTime() {
        return this.sequenceWorkerSleepTime;
    }

    public void setSequenceWorkerSleepTime(long sequenceWorkerSleepTime) {
        this.sequenceWorkerSleepTime = sequenceWorkerSleepTime;
    }
}

