/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.workers;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.state.RMDSequence;

public class RMDSequenceWorker
implements Runnable {
    private static Log log = LogFactory.getLog(RMDSequenceWorker.class);
    private long sequenceWorkerSleepTime;
    private RMDSequence rmdSequence;

    public RMDSequenceWorker(RMDSequence rmdSequence) {
        this.rmdSequence = rmdSequence;
    }

    public void run() {
        while (this.rmdSequence.getState() != 4 && System.currentTimeMillis() - this.rmdSequence.getLastAccesedTime() < this.rmdSequence.getTimeoutTime()) {
            try {
                this.rmdSequence.doActions();
            }
            catch (AxisFault e) {
                log.error((Object)("Fault occured when doing actions for the RMD Sequence " + this.rmdSequence.getSequenceID()), (Throwable)e);
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)"Could not build the message ", (Throwable)e);
            }
            try {
                Thread.sleep(this.sequenceWorkerSleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)("Stopping the RMD Sequence for " + this.rmdSequence.getSequenceID()));
    }

    public long getSequenceWorkerSleepTime() {
        return this.sequenceWorkerSleepTime;
    }

    public void setSequenceWorkerSleepTime(long sequenceWorkerSleepTime) {
        this.sequenceWorkerSleepTime = sequenceWorkerSleepTime;
    }
}

