/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.workers;

import java.io.InputStream;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.state.RMSSequence;

public class MessageWorker
implements Runnable {
    private static Log log = LogFactory.getLog(MessageWorker.class);
    private MessageContext messageContext;
    private MessageContext responseMessageContext;
    private boolean isResume;
    private boolean isInvokeAsAnonClient;
    private RMSSequence rmsSequence;

    public MessageWorker(MessageContext messageContext, boolean isResume) {
        this.messageContext = messageContext;
        this.isResume = isResume;
    }

    public MessageWorker(MessageContext messageContext, MessageContext responseMessageContext, boolean resume, boolean invokeAsAnonClient) {
        this(messageContext, resume);
        this.responseMessageContext = responseMessageContext;
        this.isInvokeAsAnonClient = invokeAsAnonClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            try {
                if (this.isResume) {
                    if (this.messageContext.isProcessingFault()) {
                        AxisEngine.resumeSendFault((MessageContext)this.messageContext);
                    } else {
                        AxisEngine.resumeSend((MessageContext)this.messageContext);
                    }
                } else {
                    AxisEngine.send((MessageContext)this.messageContext);
                }
                if (!this.isInvokeAsAnonClient) break block13;
                if (this.messageContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-only") || this.responseMessageContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse") || this.responseMessageContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
                    this.responseMessageContext.setProperty("TRANSPORT_HEADERS", this.messageContext.getProperty("TRANSPORT_HEADERS"));
                    this.responseMessageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, this.messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE));
                    this.responseMessageContext.setProperty("TRANSPORT_IN", this.messageContext.getProperty("TRANSPORT_IN"));
                    this.responseMessageContext.setTransportIn(this.messageContext.getTransportIn());
                    this.responseMessageContext.setTransportOut(this.messageContext.getTransportOut());
                    try {
                        this.handleResponse(this.responseMessageContext);
                    }
                    catch (AxisFault e) {
                        if (this.rmsSequence != null) {
                            this.rmsSequence.soapFaultOccured();
                        }
                        break block13;
                    }
                }
                if (this.responseMessageContext.getProperty("TRANSPORT_IN") == null && this.responseMessageContext.getEnvelope() == null) break block13;
                MessageContext e = this.responseMessageContext;
                synchronized (e) {
                    this.responseMessageContext.notify();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Can not send the message ...");
            }
        }
    }

    protected void handleResponse(MessageContext responseMessageContext) throws AxisFault {
        InputStream inStream;
        responseMessageContext.setSoapAction(null);
        SOAPEnvelope resenvelope = responseMessageContext.getEnvelope();
        if (resenvelope == null && (inStream = (InputStream)responseMessageContext.getProperty("TRANSPORT_IN")) != null) {
            resenvelope = TransportUtils.createSOAPMessage((MessageContext)responseMessageContext);
            if (resenvelope != null) {
                responseMessageContext.setEnvelope(resenvelope);
            } else {
                throw new AxisFault(Messages.getMessage((String)"blockingInvocationExpectsResponse"));
            }
        }
        if (resenvelope != null) {
            AxisEngine.receive((MessageContext)responseMessageContext);
        }
    }

    public boolean isInvokeAsAnonClient() {
        return this.isInvokeAsAnonClient;
    }

    public void setInvokeAsAnonClient(boolean invokeAsAnonClient) {
        this.isInvokeAsAnonClient = invokeAsAnonClient;
    }

    public RMSSequence getRmsSequence() {
        return this.rmsSequence;
    }

    public void setRmsSequence(RMSSequence rmsSequence) {
        this.rmsSequence = rmsSequence;
    }
}

