/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.workers;

import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAP12Constants;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.state.InvokerBuffer;

public class InvokerWorker
implements Runnable {
    private static Log log = LogFactory.getLog(InvokerWorker.class);
    private long sleepTime;
    private InvokerBuffer invokerBuffer;
    private Object lock = new Object();

    public InvokerWorker(InvokerBuffer invokerBuffer) {
        this.invokerBuffer = invokerBuffer;
        this.invokerBuffer.setInvokerWorker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.invokerBuffer.getState() != 6 && System.currentTimeMillis() - this.invokerBuffer.getLastAccessTime() < this.invokerBuffer.getTimeoutTime()) {
            try {
                this.invokerBuffer.doActions();
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Axis Fault has received to Invoker worker");
                if (axisFault.getFaultType() == 1) {
                    try {
                        MessageContext faultMessageContext = axisFault.getFaultMessageContext();
                        if (faultMessageContext.getTo() == null || faultMessageContext.getTo().getAddress().equals("http://www.w3.org/2005/08/addressing/anonymous") || faultMessageContext.getTo().getAddress().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous")) {
                            AxisHttpResponse response;
                            Object transportInfo = faultMessageContext.getProperty("OutTransportInfo");
                            if (transportInfo instanceof AxisHttpResponse) {
                                response = (AxisHttpResponse)transportInfo;
                                response.sendError(this.getStatusFromAxisFault(axisFault), axisFault.getMessage());
                            } else {
                                response = (HttpServletResponse)faultMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
                                if (response != null) {
                                    String status = (String)faultMessageContext.getProperty("axis2.http.response.state");
                                    if (status == null) {
                                        response.setStatus(500);
                                    } else {
                                        response.setStatus(Integer.parseInt(status));
                                    }
                                    SOAPFaultCode code = faultMessageContext.getEnvelope().getBody().getFault().getCode();
                                    OMElement valueElement = null;
                                    if (code != null) {
                                        valueElement = code.getFirstChildWithName(new QName("http://www.w3.org/2003/05/soap-envelope", "Value"));
                                    }
                                    if (valueElement != null && "Sender".equals(valueElement.getTextAsQName().getLocalPart())) {
                                        response.setStatus(400);
                                    }
                                }
                            }
                        }
                        AxisEngine.sendFault((MessageContext)axisFault.getFaultMessageContext());
                    }
                    catch (AxisFault e) {
                        log.error((Object)"Problem when sending the fault message", (Throwable)e);
                    }
                }
                log.error((Object)"Got a soap processing exception");
            }
            try {
                log.debug((Object)"Wait");
                Object axisFault = this.lock;
                synchronized (axisFault) {
                    this.lock.wait(this.sleepTime);
                }
                log.debug((Object)"Wakeup...");
            }
            catch (InterruptedException e) {
                log.error((Object)("Interupted :" + e));
            }
        }
        log.info((Object)"Stopping the invoker worker ");
    }

    public int getStatusFromAxisFault(AxisFault fault) {
        QName faultCode = fault.getFaultCode();
        if (SOAP12Constants.QNAME_SENDER_FAULTCODE.equals(faultCode) || SOAP11Constants.QNAME_SENDER_FAULTCODE.equals(faultCode)) {
            return 400;
        }
        return 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        try {
            log.debug((Object)"WakeUp");
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            log.debug((Object)"Thread notified");
        }
        catch (Exception e) {
            log.error((Object)("Failed to notify : " + e), (Throwable)e);
        }
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }
}

