/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.state;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.callback.MercuryErrorCallback;
import org.wso2.mercury.context.MercuryMessageContext;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.exception.RMSExpiresException;
import org.wso2.mercury.exception.RMSequenceCreationException;
import org.wso2.mercury.exception.SoapProcessingFaultException;
import org.wso2.mercury.message.AcknowledgmentRange;
import org.wso2.mercury.message.CreateSequenceMessage;
import org.wso2.mercury.message.RMApplicationMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.message.SequenceAcknowledgment;
import org.wso2.mercury.message.TerminateSequenceMessage;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.persistence.dto.RMSMessageDto;
import org.wso2.mercury.persistence.dto.RMSSequenceDto;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.state.Axis2Info;
import org.wso2.mercury.state.RMDSequence;
import org.wso2.mercury.state.RMSContext;
import org.wso2.mercury.workers.ErrorCallbackWorker;
import org.wso2.mercury.workers.MessageWorker;
import org.wso2.mercury.workers.RMSSequenceWorker;

public class RMSSequence {
    private static Log log = LogFactory.getLog(RMSSequence.class);
    private long retransmitTime;
    private long timeoutTime;
    private long maximumRetrasmitCount;
    public static final int STATE_0100 = 0;
    public static final int STATE_0101 = 1;
    public static final int STATE_0110 = 2;
    public static final int STATE_1110 = 3;
    public static final int STATE_1000 = 4;
    public static final int STATE_1100 = 5;
    public static final int STATE_1101 = 6;
    public static final int STATE_TERMINATE = 7;
    private int state;
    private Map messageBuffer;
    private long messageNumber = 0L;
    private long lastMessageNumber;
    private long lastCreateSequnceMessageSendTime = 0L;
    private long lastAccessedTime;
    private EndpointReference endPointReference;
    private EndpointReference ackToEpr;
    private String sequenceID;
    private Axis2Info axis2Info;
    private String sequenceOffer;
    private RMSSequenceDto persistanceDto;
    private boolean isAnnonymous;
    private RMDSequence offeredRMDSequence;
    private MercuryErrorCallback errorCallback;
    private RMSSequenceWorker rmsSequenceWorker;

    public RMSSequence(int state, EndpointReference endPointReference) {
        this.state = state;
        this.endPointReference = endPointReference;
        this.messageBuffer = new HashMap();
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public synchronized void addRMMessageContext(RMApplicationMessage message, MessageContext messageContext) throws PersistenceException {
        this.lastAccessedTime = System.currentTimeMillis();
        long number = ++this.messageNumber;
        if (this.persistanceDto != null) {
            this.persistanceDto.setMessageNumber(this.messageNumber);
        }
        Sequence sequence = message.getSequence();
        sequence.setMessageNumber(number);
        if (sequence.isLastMessage()) {
            this.lastMessageNumber = number;
            if (this.persistanceDto != null) {
                this.persistanceDto.setLastMessageNumber(this.lastMessageNumber);
            }
        }
        PersistenceManager persistenceManager = this.getPersistanceManager();
        RMSMessageDto rmsMessageDto = null;
        if (persistenceManager != null) {
            rmsMessageDto = new RMSMessageDto();
            rmsMessageDto.setMessageNumber(sequence.getMessageNumber());
            rmsMessageDto.setLastMessage(sequence.isLastMessage());
            rmsMessageDto.setSoapEnvelpe(message.getOriginalMessage().toString());
            rmsMessageDto.setSend(false);
            rmsMessageDto.setRmsSequenceID(this.persistanceDto.getId());
            rmsMessageDto.setAxisMessageID(messageContext.getMessageID());
            rmsMessageDto.setCallBackClassName(this.getCallBackClassName(messageContext));
            try {
                persistenceManager.save(rmsMessageDto, this.persistanceDto);
            }
            catch (PersistenceException e) {
                --this.messageNumber;
                this.persistanceDto.setMessageNumber(this.messageNumber);
                if (sequence.isLastMessage()) {
                    this.lastMessageNumber = 0L;
                    this.persistanceDto.setLastMessageNumber(0L);
                }
                log.error((Object)("Can not save the message with message number " + sequence.getMessageNumber()), (Throwable)e);
                throw new PersistenceException("Can not save the message with message number " + sequence.getMessageNumber(), e);
            }
        }
        this.messageBuffer.put(new Long(number), new MercuryMessageContext(rmsMessageDto, message, messageContext));
        this.notifyAll();
    }

    private String getCallBackClassName(MessageContext messageContext) {
        CallbackReceiver callbackReceiver;
        AxisCallback axisCallback;
        AxisOperation axisOperation = messageContext.getAxisOperation();
        MessageReceiver messageReceiver = axisOperation.getMessageReceiver();
        String className = null;
        if (messageReceiver instanceof CallbackReceiver && (axisCallback = (AxisCallback)(callbackReceiver = (CallbackReceiver)messageReceiver).getCallbackStore().get(messageContext.getMessageID())) != null) {
            className = axisCallback.getClass().getName();
        }
        return className;
    }

    public synchronized void doActions() throws AxisFault, RMMessageBuildingException {
        switch (this.state) {
            case 0: {
                this.retransmitCreateSequenceMessage();
                break;
            }
            case 1: {
                this.retransmitCreateSequenceMessage();
                break;
            }
            case 2: {
                this.retransmitCreateSequenceMessage();
                break;
            }
            case 3: {
                this.retransmitApplicationMessages();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.retransmitApplicationMessages();
                break;
            }
            case 6: {
                this.retransmitApplicationMessages();
            }
        }
    }

    private void retransmitCreateSequenceMessage() throws AxisFault, RMMessageBuildingException {
        if (this.lastCreateSequnceMessageSendTime == 0L || System.currentTimeMillis() - this.lastCreateSequnceMessageSendTime > this.retransmitTime) {
            this.sendCreateSequenceMessage();
            this.lastCreateSequnceMessageSendTime = System.currentTimeMillis();
        }
    }

    private void sendCreateSequenceMessage() throws AxisFault, RMMessageBuildingException {
        CreateSequenceMessage createSequenceMessage = new CreateSequenceMessage();
        createSequenceMessage.setAcksToAddress(this.ackToEpr.getAddress());
        createSequenceMessage.setSoapNamesapce(this.axis2Info.getSoapNamespaceURI());
        createSequenceMessage.setAddressingNamespace(this.axis2Info.getAddressingNamespaceURI());
        createSequenceMessage.setOfferIdentifier(this.sequenceOffer);
        MessageContext messageContext = this.getNewMessageContextUsingAxis2Info(createSequenceMessage);
        messageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence");
        AxisOperation axisOperation = null;
        axisOperation = this.axis2Info.isServerSide() ? this.axis2Info.getAxisService().getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence") : this.axis2Info.getAxisService().getOperation(ServiceClient.ANON_OUT_IN_OP);
        OperationContext operationContext = this.axis2Info.getServiceContext().createOperationContext(axisOperation);
        axisOperation.registerOperationContext(messageContext, operationContext);
        messageContext.setAxisMessage(axisOperation.getMessage("Out"));
        RMSContext rmsContext = (RMSContext)messageContext.getConfigurationContext().getProperty("MercuryRMSContext");
        rmsContext.registerRMSSequenceToMessageID(messageContext.getMessageID(), this);
        if (!this.axis2Info.isServerSide() && this.isAnnonymous) {
            MessageContext responseMessageContext = messageContext.getConfigurationContext().createMessageContext();
            responseMessageContext.setServerSide(false);
            axisOperation.registerOperationContext(responseMessageContext, operationContext);
            responseMessageContext.setOptions(messageContext.getOptions());
            responseMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse");
            responseMessageContext.setMessageID(UUIDGenerator.getUUID());
            responseMessageContext.setServiceContext(messageContext.getServiceContext());
            responseMessageContext.setAxisMessage(axisOperation.getMessage("In"));
            this.sendMessage(messageContext, responseMessageContext, false, true, false);
        } else {
            this.sendMessage(messageContext, null, false, false, false);
        }
    }

    public synchronized void createSequenceResponseReceived() throws PersistenceException {
        this.lastAccessedTime = System.currentTimeMillis();
        int currentState = this.state;
        switch (this.state) {
            case 0: {
                this.state = 5;
                break;
            }
            case 1: {
                this.state = 6;
                break;
            }
            case 2: {
                this.state = 3;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
        PersistenceManager persistenceManager = this.getPersistanceManager();
        if (persistenceManager != null) {
            this.persistanceDto.setState(this.state);
            this.persistanceDto.setLastAccessedTime(this.lastAccessedTime);
            this.persistanceDto.setSequenceID(this.sequenceID);
            try {
                persistenceManager.update(this.persistanceDto);
            }
            catch (PersistenceException e) {
                this.persistanceDto.setState(currentState);
                this.state = currentState;
                this.sequenceID = null;
                log.error((Object)"Can not updated the RMS state for received create sequene response message ", (Throwable)e);
                throw new PersistenceException("Can not updated the RMS state for received create sequene response message ", e);
            }
        }
        this.continueWork();
    }

    private void sendMessage(MessageContext messageContext, MessageContext responseMessageContext, boolean isResume, boolean isInvokeAsAnonClient, boolean isUseSameThread) {
        MessageWorker messageWorker = new MessageWorker(messageContext, responseMessageContext, isResume, isInvokeAsAnonClient);
        if (isInvokeAsAnonClient) {
            messageWorker.setRmsSequence(this);
        }
        if (isUseSameThread) {
            messageWorker.run();
        } else {
            messageContext.getConfigurationContext().getThreadPool().execute((Runnable)messageWorker);
        }
    }

    private MessageContext getNewMessageContextUsingAxis2Info(CreateSequenceMessage createSequenceMessage) throws AxisFault, RMMessageBuildingException {
        MessageContext messageContext = new MessageContext();
        messageContext.setServiceContext(this.axis2Info.getServiceContext());
        messageContext.setEnvelope(createSequenceMessage.toSOAPEnvelope());
        messageContext.setMessageID(UUIDGenerator.getUUID());
        messageContext.setTransportIn(this.axis2Info.getTransportIn());
        messageContext.setTransportOut(this.axis2Info.getTransportOut());
        messageContext.setReplyTo(this.ackToEpr);
        messageContext.setProperty("processRMControlMessage", (Object)"true");
        messageContext.setOptions(new Options());
        messageContext.getOptions().setTo(this.axis2Info.getOptions().getTo());
        messageContext.getOptions().setUseSeparateListener(this.axis2Info.getOptions().isUseSeparateListener());
        messageContext.setServerSide(this.axis2Info.isServerSide());
        return messageContext;
    }

    public void removeRelationShips(Options options) {
        if (options.getParent() != null) {
            this.removeRelationShips(options.getParent());
        }
        options.setRelationships(null);
    }

    private void retransmitApplicationMessages() throws AxisFault, RMMessageBuildingException {
        MercuryMessageContext mercuryMessageContext2 = null;
        RMApplicationMessage message = null;
        MessageContext applicationMessageContext = null;
        for (MercuryMessageContext mercuryMessageContext2 : this.messageBuffer.values()) {
            SequenceAcknowledgment sequenceAcknowledgment;
            long lastMessageSentTime = mercuryMessageContext2.getLastMessageSendTime();
            long retransmitCount = mercuryMessageContext2.getRetransmitCount();
            if (lastMessageSentTime != 0L && (System.currentTimeMillis() - lastMessageSentTime <= this.retransmitTime || retransmitCount >= this.maximumRetrasmitCount)) continue;
            message = mercuryMessageContext2.getRmApplicationMessage();
            message.getSequence().setSequenceID(this.sequenceID);
            applicationMessageContext = mercuryMessageContext2.getMessageContext();
            applicationMessageContext.setCurrentHandlerIndex(mercuryMessageContext2.getCurrentHandlerIndex());
            if (this.offeredRMDSequence != null && (sequenceAcknowledgment = this.offeredRMDSequence.getSequenceAcknowledgment()).getAcknowledgmentRanges().size() > 0) {
                message.setSequenceAcknowledgment(sequenceAcknowledgment);
            }
            applicationMessageContext.setEnvelope(message.toSOAPEnvelope());
            applicationMessageContext.setProperty("processRMControlMessage", (Object)"true");
            mercuryMessageContext2.setLastMessageSendTime(System.currentTimeMillis());
            mercuryMessageContext2.increaseRetransmitCount();
            if (!this.axis2Info.isServerSide() && this.isAnnonymous) {
                MessageContext responseMessageContext;
                if (applicationMessageContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-only")) {
                    responseMessageContext = this.axis2Info.getConfigurationContext().createMessageContext();
                    responseMessageContext.setServerSide(false);
                    responseMessageContext.setServiceContext(this.axis2Info.getServiceContext());
                    responseMessageContext.setMessageID(UUIDGenerator.getUUID());
                    AxisService axisServce = this.axis2Info.getAxisService();
                    AxisOperation inOnlyOperation = null;
                    if (applicationMessageContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage") && this.offeredRMDSequence != null) {
                        responseMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
                        inOnlyOperation = axisServce.getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
                    } else {
                        responseMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement");
                        inOnlyOperation = axisServce.getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement");
                    }
                    OperationContext operationContext = this.axis2Info.getServiceContext().createOperationContext(inOnlyOperation);
                    inOnlyOperation.registerOperationContext(responseMessageContext, operationContext);
                    responseMessageContext.setAxisMessage(inOnlyOperation.getMessage("In"));
                    applicationMessageContext.setProperty("piggybackMessage", (Object)responseMessageContext);
                    this.sendMessage(applicationMessageContext, responseMessageContext, true, true, false);
                    continue;
                }
                responseMessageContext = applicationMessageContext.getOperationContext().getMessageContext("In");
                this.sendMessage(applicationMessageContext, responseMessageContext, true, true, false);
                continue;
            }
            this.sendMessage(applicationMessageContext, null, true, false, false);
        }
    }

    public synchronized void sendApplicationMessageResponse(MessageContext inboundMessageContext, long inMessageNumber) throws AxisFault, RMMessageBuildingException {
        if (this.messageBuffer.containsKey(new Long(inMessageNumber))) {
            SequenceAcknowledgment sequenceAcknowledgment;
            MercuryMessageContext mercuryMessageContext = (MercuryMessageContext)this.messageBuffer.get(new Long(inMessageNumber));
            RMApplicationMessage message = mercuryMessageContext.getRmApplicationMessage();
            message.getSequence().setSequenceID(this.sequenceID);
            MessageContext outBoundMessageContext = mercuryMessageContext.getMessageContext();
            outBoundMessageContext.setCurrentHandlerIndex(mercuryMessageContext.getCurrentHandlerIndex());
            if (this.offeredRMDSequence != null && (sequenceAcknowledgment = this.offeredRMDSequence.getSequenceAcknowledgment()).getAcknowledgmentRanges().size() > 0) {
                message.setSequenceAcknowledgment(sequenceAcknowledgment);
            }
            outBoundMessageContext.setEnvelope(message.toSOAPEnvelope());
            outBoundMessageContext.setProperty("processRMControlMessage", (Object)"true");
            outBoundMessageContext.setTransportOut(inboundMessageContext.getTransportOut());
            outBoundMessageContext.setProperty("TRANSPORT_OUT", inboundMessageContext.getProperty("TRANSPORT_OUT"));
            outBoundMessageContext.setProperty("OutTransportInfo", inboundMessageContext.getProperty("OutTransportInfo"));
            outBoundMessageContext.setProperty("RequestResponseTransportControl", inboundMessageContext.getProperty("RequestResponseTransportControl"));
            try {
                if (outBoundMessageContext.isProcessingFault()) {
                    AxisEngine.resumeSendFault((MessageContext)outBoundMessageContext);
                } else {
                    AxisEngine.resumeSend((MessageContext)outBoundMessageContext);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can not resume message sending");
            }
            mercuryMessageContext.setLastMessageSendTime(System.currentTimeMillis());
        } else if (inMessageNumber > this.messageNumber) {
            this.offeredRMDSequence.getInvokerBuffer().continueWork();
            try {
                this.wait();
                this.sendApplicationMessageResponse(inboundMessageContext, inMessageNumber);
            }
            catch (InterruptedException e) {}
        } else if (this.offeredRMDSequence != null) {
            this.offeredRMDSequence.sendSequenceAcknowledgementMessage(inboundMessageContext);
        }
    }

    public synchronized void sequenceAcknowledgmentReceived(List acknowledgmentRanges) throws PersistenceException {
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.persistanceDto != null) {
            this.persistanceDto.setLastAccessedTime(this.lastAccessedTime);
        }
        switch (this.state) {
            case 0: {
                log.error((Object)"Acknowledgment received before statring the sequence");
                break;
            }
            case 1: {
                log.error((Object)"Acknowledgment received before statring the sequence");
                break;
            }
            case 2: {
                log.error((Object)"Acknowledgment received before statring the sequence");
                break;
            }
            case 3: {
                this.processRangesAndUpdateState(acknowledgmentRanges, 7);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.processRangesAndUpdateState(acknowledgmentRanges, 4);
                break;
            }
            case 6: {
                this.processRangesAndUpdateState(acknowledgmentRanges, 7);
            }
        }
        this.continueWork();
    }

    private void processRangesAndUpdateState(List acknowledgmentRanges, int newState) throws PersistenceException {
        Set acknowledgedMessages = this.processAcknowledgeMessages(acknowledgmentRanges);
        PersistenceManager persistenceManager = this.getPersistanceManager();
        if (persistenceManager != null) {
            if (this.messageBuffer.size() == acknowledgedMessages.size()) {
                this.persistanceDto.setState(newState);
            }
            HashSet<RMSMessageDto> acknolwdgeMessageDtos = new HashSet<RMSMessageDto>();
            MercuryMessageContext mercuryMessageContext = null;
            Iterator iter = acknowledgedMessages.iterator();
            while (iter.hasNext()) {
                mercuryMessageContext = (MercuryMessageContext)this.messageBuffer.get(iter.next());
                mercuryMessageContext.getRmsPersistanceDto().setSend(true);
                acknolwdgeMessageDtos.add(mercuryMessageContext.getRmsPersistanceDto());
            }
            try {
                persistenceManager.updateMessagesAsSend(acknolwdgeMessageDtos, this.persistanceDto);
            }
            catch (PersistenceException e) {
                this.persistanceDto.setState(this.state);
                Iterator iter2 = acknowledgedMessages.iterator();
                while (iter2.hasNext()) {
                    mercuryMessageContext = (MercuryMessageContext)this.messageBuffer.get(iter2.next());
                    mercuryMessageContext.getRmsPersistanceDto().setSend(false);
                }
                log.error((Object)"Can not update the RMSMessages", (Throwable)e);
                throw new PersistenceException("Can not update the RMSMessages", e);
            }
        }
        Iterator iter = acknowledgedMessages.iterator();
        while (iter.hasNext()) {
            this.messageBuffer.remove(iter.next());
        }
        if (this.messageBuffer.size() == 0) {
            this.state = newState;
        }
    }

    private Set processAcknowledgeMessages(List acknowledgmentRanges) {
        HashSet<Long> acknowledgedMessages = new HashSet<Long>();
        for (Long key : this.messageBuffer.keySet()) {
            if (!this.isNumberAcknowledged(key, acknowledgmentRanges)) continue;
            acknowledgedMessages.add(key);
        }
        return acknowledgedMessages;
    }

    public boolean isNumberAcknowledged(long number, List acknowledgments) {
        boolean isNumberAcknowledged = false;
        AcknowledgmentRange acknowledgmentRange2 = null;
        for (AcknowledgmentRange acknowledgmentRange2 : acknowledgments) {
            if (!acknowledgmentRange2.isNumberInRange(number)) continue;
            isNumberAcknowledged = true;
            break;
        }
        return isNumberAcknowledged;
    }

    public synchronized void applicationMessageReceivedFromClient(RMApplicationMessage message, MessageContext messageContext) throws PersistenceException {
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.persistanceDto != null) {
            this.persistanceDto.setLastAccessedTime(this.lastAccessedTime);
        }
        int currentState = this.state;
        try {
            switch (this.state) {
                case 0: {
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
                case 1: {
                    this.state = 6;
                    if (this.persistanceDto != null) {
                        this.persistanceDto.setState(this.state);
                    }
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
                case 2: {
                    log.error((Object)"Receiving an application message after receiving the terminate message");
                    break;
                }
                case 3: {
                    log.error((Object)"Receiving an application message after receiving the terminate message");
                    break;
                }
                case 4: {
                    this.state = 5;
                    if (this.persistanceDto != null) {
                        this.persistanceDto.setState(this.state);
                    }
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
                case 5: {
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
                case 6: {
                    this.addRMMessageContext(message, messageContext);
                }
            }
        }
        catch (PersistenceException e) {
            this.state = currentState;
            this.persistanceDto.setState(currentState);
            log.error((Object)"Can not add the message ", (Throwable)e);
            throw new PersistenceException("Can not add the message ", e);
        }
    }

    public synchronized void lastMessageReceivedFromClient(RMApplicationMessage message, MessageContext messageContext) throws PersistenceException {
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.persistanceDto != null) {
            this.persistanceDto.setLastAccessedTime(this.lastAccessedTime);
        }
        int currentState = this.state;
        try {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    if (this.persistanceDto != null) {
                        this.persistanceDto.setState(this.state);
                    }
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
                case 1: {
                    log.error((Object)"Receiving a last message after one last message receives");
                    break;
                }
                case 2: {
                    log.error((Object)"Receiving a last message after one last message receives");
                    break;
                }
                case 3: {
                    log.error((Object)"Receiving a last message after one last message receives");
                    break;
                }
                case 4: {
                    this.state = 6;
                    if (this.persistanceDto != null) {
                        this.persistanceDto.setState(this.state);
                    }
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
                case 5: {
                    this.state = 6;
                    if (this.persistanceDto != null) {
                        this.persistanceDto.setState(this.state);
                    }
                    this.addRMMessageContext(message, messageContext);
                    break;
                }
            }
        }
        catch (PersistenceException e) {
            this.state = currentState;
            this.persistanceDto.setState(currentState);
            log.error((Object)"Can not save the last message ", (Throwable)e);
            throw new PersistenceException("Can not save the last message ", e);
        }
        this.continueWork();
    }

    public synchronized void terminateMessageReceivedFromClient() throws PersistenceException {
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.persistanceDto != null) {
            this.persistanceDto.setLastAccessedTime(this.lastAccessedTime);
        }
        int currentState = this.state;
        switch (this.state) {
            case 0: {
                this.state = 2;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                log.error((Object)"Receiving a termiante message after getting one terminate message");
                break;
            }
            case 3: {
                log.error((Object)"Receiving a termiante message after getting one terminate message");
                break;
            }
            case 4: {
                this.state = 7;
                break;
            }
            case 5: {
                this.state = 3;
                break;
            }
        }
        PersistenceManager persistenceManager = this.getPersistanceManager();
        if (persistenceManager != null) {
            this.persistanceDto.setState(this.state);
            try {
                persistenceManager.update(this.persistanceDto);
            }
            catch (PersistenceException e) {
                this.persistanceDto.setState(currentState);
                this.state = currentState;
                log.error((Object)"Can not update the state", (Throwable)e);
                throw new PersistenceException("Can not update the state", e);
            }
        }
    }

    public synchronized void sendTerminateSequenceMessage(MessageContext inboundMessageContext) throws AxisFault, RMMessageBuildingException {
        if (this.sequenceID == null) {
            log.info((Object)"Sequence has been terminated due to an error");
            return;
        }
        log.info((Object)("Sending the termainate message for the sequence " + this.sequenceID));
        PersistenceManager persistenceManager = this.getPersistanceManager();
        if (persistenceManager != null) {
            this.persistanceDto.setLastAccessedTime(System.currentTimeMillis());
            this.persistanceDto.setEndTime(System.currentTimeMillis());
            try {
                persistenceManager.update(this.persistanceDto);
            }
            catch (PersistenceException e) {
                log.error((Object)"Error in updating the sequence to terminate state. how ever sequene is terminated correctly ");
            }
        }
        TerminateSequenceMessage terminateSequenceMessage = new TerminateSequenceMessage(this.sequenceID);
        terminateSequenceMessage.setSoapNamesapce(this.axis2Info.getSoapNamespaceURI());
        MessageContext messageContext = this.getNewMessageContextUsingAxis2Info(terminateSequenceMessage, inboundMessageContext);
        messageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence");
        AxisOperation axisOperation = null;
        if (this.axis2Info.isServerSide()) {
            axisOperation = this.axis2Info.getAxisService().getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence");
            messageContext.setAxisMessage(axisOperation.getMessage("In"));
        } else {
            axisOperation = this.axis2Info.getAxisService().getOperation(ServiceClient.ANON_OUT_ONLY_OP);
            messageContext.setAxisMessage(axisOperation.getMessage("Out"));
        }
        OperationContext operationContext = this.axis2Info.getServiceContext().createOperationContext(axisOperation);
        axisOperation.registerOperationContext(messageContext, operationContext);
        if (inboundMessageContext == null) {
            if (this.offeredRMDSequence != null) {
                MessageContext responseMessageContext = this.axis2Info.getConfigurationContext().createMessageContext();
                responseMessageContext.setServerSide(false);
                responseMessageContext.setServiceContext(this.axis2Info.getServiceContext());
                responseMessageContext.setMessageID(UUIDGenerator.getUUID());
                OperationContext responseOperationContext = this.axis2Info.getServiceContext().createOperationContext(axisOperation);
                responseMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence");
                axisOperation = this.axis2Info.getAxisService().getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence");
                axisOperation.registerOperationContext(responseMessageContext, responseOperationContext);
                responseMessageContext.setAxisMessage(axisOperation.getMessage("In"));
                messageContext.setProperty("piggybackMessage", (Object)responseMessageContext);
                this.sendMessage(messageContext, responseMessageContext, false, true, false);
            } else {
                this.sendMessage(messageContext, null, false, false, false);
            }
        } else {
            this.sendMessage(messageContext, null, false, false, true);
        }
    }

    private MessageContext getNewMessageContextUsingAxis2Info(TerminateSequenceMessage terminateSequenceMessage, MessageContext inboundMessageContext) throws AxisFault, RMMessageBuildingException {
        SequenceAcknowledgment sequenceAcknowledgment;
        MessageContext messageContext = new MessageContext();
        messageContext.setServiceContext(this.axis2Info.getServiceContext());
        if (this.offeredRMDSequence != null && (sequenceAcknowledgment = this.offeredRMDSequence.getSequenceAcknowledgment()).getAcknowledgmentRanges().size() > 0) {
            terminateSequenceMessage.setSequenceAcknowledgment(sequenceAcknowledgment);
        }
        messageContext.setEnvelope(terminateSequenceMessage.toSOAPEnvelope());
        messageContext.setMessageID(UUIDGenerator.getUUID());
        messageContext.setProperty("processRMControlMessage", (Object)"true");
        messageContext.setOptions(new Options());
        messageContext.getOptions().setUseSeparateListener(this.axis2Info.getOptions().isUseSeparateListener());
        messageContext.setServerSide(this.axis2Info.isServerSide());
        if (inboundMessageContext == null) {
            messageContext.setTransportOut(this.axis2Info.getTransportOut());
            messageContext.setTo(this.axis2Info.getOptions().getTo());
        } else {
            messageContext.setProperty("RECV_RESULTS", inboundMessageContext.getProperty("RECV_RESULTS"));
            messageContext.setProperty("messageType", inboundMessageContext.getProperty("messageType"));
            messageContext.setTransportOut(inboundMessageContext.getTransportOut());
            messageContext.setProperty("TRANSPORT_OUT", inboundMessageContext.getProperty("TRANSPORT_OUT"));
            messageContext.setProperty("OutTransportInfo", inboundMessageContext.getProperty("OutTransportInfo"));
            messageContext.setProperty("RequestResponseTransportControl", inboundMessageContext.getProperty("RequestResponseTransportControl"));
        }
        return messageContext;
    }

    public void save(long internalKeyID) throws PersistenceException {
        RMSSequenceDto rmsSequenceDto = new RMSSequenceDto();
        rmsSequenceDto.setState(this.state);
        rmsSequenceDto.setMessageNumber(this.messageNumber);
        rmsSequenceDto.setLastMessageNumber(this.lastMessageNumber);
        rmsSequenceDto.setEndPointAddress(this.endPointReference.getAddress());
        if (this.ackToEpr != null) {
            rmsSequenceDto.setAckToEpr(this.ackToEpr.getAddress());
        }
        rmsSequenceDto.setSequenceOffer(this.sequenceOffer);
        rmsSequenceDto.setInternalKeyID(internalKeyID);
        rmsSequenceDto.setStartTime(System.currentTimeMillis());
        rmsSequenceDto.setSequenceID(this.sequenceID);
        this.getPersistanceManager().save(rmsSequenceDto);
        this.persistanceDto = rmsSequenceDto;
    }

    private PersistenceManager getPersistanceManager() {
        PersistenceManager persistenceManager = null;
        if (this.axis2Info.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
            persistenceManager = (PersistenceManager)this.axis2Info.getConfigurationContext().getProperty("rmPersistanceManager");
        }
        return persistenceManager;
    }

    public void populatePersistnaceData(MessageContext messageContext, RMSSequenceDto rmsSequenceDto) throws PersistenceException, AxisFault {
        this.persistanceDto = rmsSequenceDto;
        this.sequenceID = rmsSequenceDto.getSequenceID();
        this.messageNumber = rmsSequenceDto.getMessageNumber();
        this.lastMessageNumber = rmsSequenceDto.getLastMessageNumber();
        this.ackToEpr = new EndpointReference(rmsSequenceDto.getAckToEpr());
        this.sequenceOffer = rmsSequenceDto.getSequenceOffer();
        this.lastAccessedTime = System.currentTimeMillis();
        PersistenceManager persistenceManager = this.getPersistanceManager();
        List rmsMessageDtos = persistenceManager.getRMSMessagesWithRMSSequenceID(this.persistanceDto.getId());
        RMSMessageDto rmsMessageDto2 = null;
        for (RMSMessageDto rmsMessageDto2 : rmsMessageDtos) {
            MessageReceiver messageReceiver;
            if (!rmsMessageDto2.isSend()) {
                MessageContext newMessageContext = new MessageContext();
                newMessageContext.setCurrentHandlerIndex(messageContext.getCurrentHandlerIndex());
                newMessageContext.setCurrentPhaseIndex(messageContext.getCurrentPhaseIndex());
                newMessageContext.setExecutionChain(messageContext.getExecutionChain());
                newMessageContext.setServiceContext(messageContext.getServiceContext());
                newMessageContext.setMessageID(rmsMessageDto2.getAxisMessageID());
                newMessageContext.setTransportIn(messageContext.getTransportIn());
                newMessageContext.setTransportOut(messageContext.getTransportOut());
                newMessageContext.setTo(messageContext.getTo());
                newMessageContext.setReplyTo(messageContext.getReplyTo());
                newMessageContext.setOptions(new Options());
                newMessageContext.getOptions().setTo(messageContext.getTo());
                newMessageContext.getOptions().setUseSeparateListener(messageContext.getOptions().isUseSeparateListener());
                newMessageContext.getOptions().setAction(messageContext.getOptions().getAction());
                newMessageContext.setServerSide(messageContext.isServerSide());
                AxisOperation inOutOperation = messageContext.getAxisOperation();
                OperationContext operationContext = messageContext.getServiceContext().createOperationContext(inOutOperation);
                inOutOperation.registerOperationContext(newMessageContext, operationContext);
                messageContext.setAxisMessage(inOutOperation.getMessage("Out"));
                RMApplicationMessage rmApplicationMessage = new RMApplicationMessage(this.getSoapEnvelope(rmsMessageDto2.getSoapEnvelpe()));
                Sequence sequence = rmApplicationMessage.getSequence();
                if (sequence == null) {
                    sequence = new Sequence();
                    rmApplicationMessage.setSequence(sequence);
                }
                sequence.setLastMessage(rmsMessageDto2.isLastMessage());
                sequence.setMessageNumber(rmsMessageDto2.getMessageNumber());
                MercuryMessageContext mercuryMessageContext = new MercuryMessageContext(rmsMessageDto2, rmApplicationMessage, newMessageContext);
                this.messageBuffer.put(new Long(rmsMessageDto2.getMessageNumber()), mercuryMessageContext);
            }
            if (!messageContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-in") || !((messageReceiver = messageContext.getAxisOperation().getMessageReceiver()) instanceof CallbackReceiver)) continue;
            CallbackReceiver callbackReceiver = (CallbackReceiver)messageReceiver;
            String className = rmsMessageDto2.getCallBackClassName();
            try {
                Class<?> callBackClass = Class.forName(className);
                Object callBackObject = callBackClass.newInstance();
                callbackReceiver.addCallback(rmsMessageDto2.getAxisMessageID(), (AxisCallback)callBackObject);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Can not instantiate the callback class with name " + className));
                throw new PersistenceException("Can not instantiate the callback class with name " + className);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Can not access the callback class with name " + className));
                throw new PersistenceException("Can not access the callback class with name " + className);
            }
            catch (InstantiationException e) {
                log.error((Object)("Can not instantiate the callback class with name " + className));
                throw new PersistenceException("Can not instantiate the callback class with name " + className);
            }
        }
    }

    private SOAPEnvelope getSoapEnvelope(String soapEnvelpe) throws PersistenceException {
        try {
            XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(soapEnvelpe.getBytes()));
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlReader);
            SOAPEnvelope soapEnvelope = (SOAPEnvelope)builder.getDocumentElement();
            soapEnvelope.build();
            String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
            if (soapEnvelope.getHeader() == null) {
                SOAPFactory soapFactory = null;
                soapFactory = soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
                soapFactory.createSOAPHeader(soapEnvelope);
            }
            return soapEnvelope;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Problem with the stored message", (Throwable)e);
            throw new PersistenceException("Problem with the stored message", e);
        }
    }

    public synchronized void invalidCreateSequenceResponseReceived() throws AxisFault {
        this.terminateRMSSequence();
        if (this.errorCallback != null) {
            ErrorCallbackWorker errorCallbackWorker = new ErrorCallbackWorker(this.errorCallback, new RMSequenceCreationException("Invalid Sequence Response Received"));
            this.axis2Info.getConfigurationContext().getThreadPool().execute((Runnable)errorCallbackWorker);
        }
    }

    public synchronized void rmsSequenceExpired() throws AxisFault {
        this.terminateRMSSequence();
        if (this.errorCallback != null) {
            ErrorCallbackWorker errorCallbackWorker = new ErrorCallbackWorker(this.errorCallback, new RMSExpiresException("RMS Sequence has expires before properly terminating the sequence"));
            this.axis2Info.getConfigurationContext().getThreadPool().execute((Runnable)errorCallbackWorker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateRMSSequence() throws AxisFault {
        this.state = 7;
        MercuryMessageContext mercuryMessageContext2 = null;
        MessageContext messageContext = null;
        for (MercuryMessageContext mercuryMessageContext2 : this.messageBuffer.values()) {
            MessageContext inMessageContext;
            messageContext = mercuryMessageContext2.getMessageContext();
            if (!messageContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-in")) continue;
            MessageContext messageContext2 = inMessageContext = messageContext.getOperationContext().getMessageContext("In");
            synchronized (messageContext2) {
                inMessageContext.notify();
            }
        }
        if (this.offeredRMDSequence != null) {
            this.offeredRMDSequence.terminate();
        }
    }

    public synchronized void soapFaultOccured() throws AxisFault {
        this.terminateRMSSequence();
        if (this.errorCallback != null) {
            ErrorCallbackWorker errorCallbackWorker = new ErrorCallbackWorker(this.errorCallback, new SoapProcessingFaultException("Problem with processing the soap message"));
            this.axis2Info.getConfigurationContext().getThreadPool().execute((Runnable)errorCallbackWorker);
        }
    }

    public void continueWork() {
        log.debug((Object)"continueWork");
        if (this.rmsSequenceWorker != null) {
            this.rmsSequenceWorker.wakeUp();
        } else {
            log.debug((Object)"NO RMS Sequence Worker ??? ");
        }
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(String sequenceID) {
        this.sequenceID = sequenceID;
    }

    public EndpointReference getAckToEpr() {
        return this.ackToEpr;
    }

    public void setAckToEpr(EndpointReference ackToEpr) {
        this.ackToEpr = ackToEpr;
    }

    public synchronized int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public synchronized long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public Axis2Info getAxis2Info() {
        return this.axis2Info;
    }

    public void setAxis2Info(Axis2Info axis2Info) {
        this.axis2Info = axis2Info;
    }

    public String getSequenceOffer() {
        return this.sequenceOffer;
    }

    public void setSequenceOffer(String sequenceOffer) {
        this.sequenceOffer = sequenceOffer;
    }

    public RMSSequenceDto getPersistanceDto() {
        return this.persistanceDto;
    }

    public void setPersistanceDto(RMSSequenceDto persistanceDto) {
        this.persistanceDto = persistanceDto;
    }

    public boolean isAnnonymous() {
        return this.isAnnonymous;
    }

    public void setAnnonymous(boolean annonymous) {
        this.isAnnonymous = annonymous;
    }

    public RMDSequence getOfferedRMDSequence() {
        return this.offeredRMDSequence;
    }

    public void setOfferedRMDSequence(RMDSequence offeredRMDSequence) {
        this.offeredRMDSequence = offeredRMDSequence;
    }

    public MercuryErrorCallback getErrorCallback() {
        return this.errorCallback;
    }

    public void setErrorCallback(MercuryErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    public void setRMSSequenceWorker(RMSSequenceWorker w) {
        this.rmsSequenceWorker = w;
    }

    public long getRetransmitTime() {
        return this.retransmitTime;
    }

    public void setRetransmitTime(long retransmitTime) {
        this.retransmitTime = retransmitTime;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.timeoutTime = timeoutTime;
    }

    public long getMaximumRetrasmitCount() {
        return this.maximumRetrasmitCount;
    }

    public void setMaximumRetrasmitCount(long maximumRetrasmitCount) {
        this.maximumRetrasmitCount = maximumRetrasmitCount;
    }
}

