/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.keys.InternalSequenceKey;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.persistence.dto.InternalKeyDto;
import org.wso2.mercury.persistence.dto.RMSSequenceDto;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.state.Axis2Info;
import org.wso2.mercury.state.RMDContext;
import org.wso2.mercury.state.RMSSequence;
import org.wso2.mercury.util.MercuryParameterHandler;
import org.wso2.mercury.util.RMDispatchInfo;
import org.wso2.mercury.workers.RMSSequenceWorker;

public class RMSContext {
    private static Log log = LogFactory.getLog(RMDContext.class);
    private Map iSKRMSSequenceMap = new HashMap();
    private Map messageIDRMSSequenceMap = new HashMap();
    private Map sequenceIDRMSSequenceMap = new HashMap();
    private ConfigurationContext configurationContext;

    public RMSContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public synchronized RMSSequence getRMSSequence(String messageID, String sequenceID) {
        RMSSequence rmsSequence = this.getRMSSequenceWithMessageID(messageID);
        if (rmsSequence != null) {
            this.unRegisterRMSSequenceWithMessageID(messageID);
            if (!this.isContainsRMSSequence(rmsSequence)) {
                this.registerRMSSequenceToSequenceID(sequenceID, rmsSequence);
                rmsSequence.setSequenceID(sequenceID);
            }
        }
        return rmsSequence;
    }

    public synchronized void resumeSequence(InternalSequenceKey key, MessageContext msgContext) throws PersistenceException, AxisFault {
        PersistenceManager persistenceManager = this.getPersistanceManager();
        if (persistenceManager != null) {
            InternalKeyDto internalKeyDto = this.getInternalKey(key, persistenceManager);
            List rmsSequeces = persistenceManager.getRMSSquenceWithInternalKey(internalKeyDto.getId());
            if (rmsSequeces.size() != 1) {
                throw new PersistenceException("There are either zero or more than one RMS Sequences for internak key with id " + internalKeyDto.getId());
            }
            RMSSequenceDto rmsSequenceDto = (RMSSequenceDto)rmsSequeces.get(0);
            RMSSequence rmsSequence = new RMSSequence(rmsSequenceDto.getState(), new EndpointReference(rmsSequenceDto.getEndPointAddress()));
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportInDescription transportIn = msgContext.getTransportIn();
            if (transportIn == null) {
                transportIn = msgContext.getOptions().getTransportIn();
            }
            if (transportIn == null) {
                transportIn = ClientUtils.inferInTransport((AxisConfiguration)msgContext.getConfigurationContext().getAxisConfiguration(), (Options)msgContext.getOptions(), (MessageContext)msgContext);
            }
            Axis2Info axis2Info = new Axis2Info();
            axis2Info.setServiceContext(msgContext.getServiceContext());
            axis2Info.setOptions(msgContext.getOptions());
            axis2Info.setTransportIn(transportIn);
            axis2Info.setTransportOut(transportOut);
            axis2Info.setServerSide(msgContext.isServerSide());
            axis2Info.setSoapNamespaceURI(msgContext.getEnvelope().getNamespace().getNamespaceURI());
            axis2Info.setProperties(msgContext.getProperties());
            rmsSequence.setAxis2Info(axis2Info);
            rmsSequence.populatePersistnaceData(msgContext, rmsSequenceDto);
            MercuryParameterHandler mercuryParameterHandler = new MercuryParameterHandler((AxisDescription)msgContext.getAxisService());
            rmsSequence.setRetransmitTime(mercuryParameterHandler.getRMSSequenceRetransmitTime());
            rmsSequence.setTimeoutTime(mercuryParameterHandler.getRMSSequenceTimeout());
            rmsSequence.setMaximumRetrasmitCount(mercuryParameterHandler.getRMSMaximumRetransmitCount());
            this.registerRMSSequenceToInternalKey(key, rmsSequence);
            if (rmsSequence.getSequenceID() != null) {
                this.registerRMSSequenceToSequenceID(rmsSequence.getSequenceID(), rmsSequence);
            }
            if (msgContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-in")) {
                RMDispatchInfo rmDispatchInfo = (RMDispatchInfo)msgContext.getConfigurationContext().getProperty("RMDispatchInfo");
                rmDispatchInfo.addMapping(rmsSequenceDto.getSequenceOffer(), msgContext.getAxisOperation());
                RMDContext rmdContext = (RMDContext)msgContext.getConfigurationContext().getProperty("MercuryRMDContext");
                rmdContext.loadRMDSequenceFromPersistanceStorage(rmsSequenceDto.getSequenceOffer(), msgContext);
            }
            RMSSequenceWorker rmsSequenceWorker = new RMSSequenceWorker(rmsSequence);
            rmsSequenceWorker.setSequenceWorkerSleepTime(mercuryParameterHandler.getRMSSequenceWorkerSleepTime());
            this.configurationContext.getThreadPool().execute((Runnable)rmsSequenceWorker);
        }
    }

    private InternalKeyDto getInternalKey(InternalSequenceKey key, PersistenceManager persistenceManager) throws PersistenceException {
        List internalKeys = persistenceManager.getInternalKey(key.getInternalKey(), key.getEndPointAddress());
        InternalKeyDto internalKeyDto2 = null;
        InternalKeyDto maxInternalKey = new InternalKeyDto();
        maxInternalKey.setId(0L);
        if (internalKeys.size() == 0) {
            throw new PersistenceException("There are no internal keys for Key " + key.getInternalKey() + " toAddress " + key.getEndPointAddress());
        }
        for (InternalKeyDto internalKeyDto2 : internalKeys) {
            if (maxInternalKey.getId() >= internalKeyDto2.getId()) continue;
            maxInternalKey = internalKeyDto2;
        }
        return maxInternalKey;
    }

    private PersistenceManager getPersistanceManager() {
        PersistenceManager persistenceManager = null;
        if (this.configurationContext.getProperty("rmPersistanceManager") != null) {
            persistenceManager = (PersistenceManager)this.configurationContext.getProperty("rmPersistanceManager");
        }
        return persistenceManager;
    }

    public synchronized void removeExpiredSequences() {
        this.removeRMSSequenceFromMap(this.iSKRMSSequenceMap);
        this.removeRMSSequenceFromMap(this.messageIDRMSSequenceMap);
        this.removeRMSSequenceFromMap(this.sequenceIDRMSSequenceMap);
    }

    private void removeRMSSequenceFromMap(Map map) {
        ArrayList<Object> expiredSequences = new ArrayList<Object>();
        Object key2 = null;
        RMSSequence rmsSequence = null;
        for (Object key2 : map.keySet()) {
            rmsSequence = (RMSSequence)map.get(key2);
            if (rmsSequence.getState() != 7 && System.currentTimeMillis() - rmsSequence.getLastAccessedTime() <= rmsSequence.getTimeoutTime()) continue;
            expiredSequences.add(key2);
        }
        for (Object key2 : expiredSequences) {
            log.info((Object)("Removing the sequence with key" + key2.toString() + " from the RMSContext "));
            map.remove(key2);
        }
    }

    public synchronized void registerRMSSequenceToInternalKey(InternalSequenceKey key, RMSSequence rmsSequence) {
        this.iSKRMSSequenceMap.put(key, rmsSequence);
    }

    public synchronized void registerRMSSequenceToMessageID(String messageID, RMSSequence rmsSequence) {
        this.messageIDRMSSequenceMap.put(messageID, rmsSequence);
    }

    public void registerRMSSequenceToSequenceID(String sequenceID, RMSSequence rmsSequence) {
        this.sequenceIDRMSSequenceMap.put(sequenceID, rmsSequence);
    }

    public synchronized RMSSequence getRMSSeqenceWithInternalKey(InternalSequenceKey key) {
        return (RMSSequence)this.iSKRMSSequenceMap.get(key);
    }

    public RMSSequence getRMSSequenceWithMessageID(String messageID) {
        return (RMSSequence)this.messageIDRMSSequenceMap.get(messageID);
    }

    public synchronized RMSSequence getRMSSequenceWithSequenceID(String sequenceID) {
        return (RMSSequence)this.sequenceIDRMSSequenceMap.get(sequenceID);
    }

    public void unRegisterRMSSequenceWithInternalKey(InternalSequenceKey key) {
        this.iSKRMSSequenceMap.remove(key);
    }

    public void unRegisterRMSSequenceWithMessageID(String messageID) {
        this.messageIDRMSSequenceMap.remove(messageID);
    }

    public synchronized void unRegisterRMSSequenceWithSequenceID(String sequenceID) {
        this.sequenceIDRMSSequenceMap.remove(sequenceID);
    }

    public boolean isContainsRMSSequence(RMSSequence rmsSequence) {
        return this.sequenceIDRMSSequenceMap.values().contains(rmsSequence);
    }

    public Map getiSKRMSSequenceMap() {
        return this.iSKRMSSequenceMap;
    }

    public void setiSKRMSSequenceMap(Map iSKRMSSequenceMap) {
        this.iSKRMSSequenceMap = iSKRMSSequenceMap;
    }

    public Map getMessageIDRMSSequenceMap() {
        return this.messageIDRMSSequenceMap;
    }

    public void setMessageIDRMSSequenceMap(Map messageIDRMSSequenceMap) {
        this.messageIDRMSSequenceMap = messageIDRMSSequenceMap;
    }

    public Map getSequenceIDRMSSequenceMap() {
        return this.sequenceIDRMSSequenceMap;
    }

    public void setSequenceIDRMSSequenceMap(Map sequenceIDRMSSequenceMap) {
        this.sequenceIDRMSSequenceMap = sequenceIDRMSSequenceMap;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

