/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.state;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.context.MercuryMessageContext;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.Accept;
import org.wso2.mercury.message.CreateSequenceResponseMessage;
import org.wso2.mercury.message.SequenceAcknowledgment;
import org.wso2.mercury.message.SequenceAcknowledgmentMessage;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.persistence.dto.InvokerBufferDto;
import org.wso2.mercury.persistence.dto.RMDSequenceDto;
import org.wso2.mercury.persistence.dto.SequenceReceivedNumberDto;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.state.Axis2Info;
import org.wso2.mercury.state.InvokerBuffer;
import org.wso2.mercury.state.RMSSequence;
import org.wso2.mercury.workers.MessageWorker;

public class RMDSequence {
    private static Log log = LogFactory.getLog(RMDSequence.class);
    public static final int STATE_00 = 0;
    public static final int STATE_10 = 1;
    public static final int STATE_11 = 2;
    public static final int STATE_COMPLETED = 3;
    public static final int STATE_TERMINATED = 4;
    private long retransmitTime;
    private long timeoutTime;
    private String sequenceID;
    private int state;
    private EndpointReference acksTo;
    private long lastCreateSequceResponseMessageSentTime = 0L;
    private long lastAcknowledgmentSentTime = 0L;
    private long lastAccesedTime = 0L;
    private MessageContext createSequenceMessageContext;
    private Axis2Info axis2Info;
    private Set receivedMessageNumbers;
    private long lastMessageNumber = 0L;
    private InvokerBuffer invokerBuffer;
    private RMDSequenceDto persistanceDto;
    private boolean isAnonymous;
    private String selfAcksToEPR;
    private RMSSequence offeredRMSSequence;

    public RMDSequence(int state) {
        this.state = state;
        this.receivedMessageNumbers = new HashSet();
        this.lastAccesedTime = System.currentTimeMillis();
        this.invokerBuffer = new InvokerBuffer(1);
    }

    public void setInvokerBufferPersistanceManager() {
        this.invokerBuffer.setPersistanceManager(this.getPersistanceManager());
    }

    public synchronized void doActions() throws AxisFault, RMMessageBuildingException {
        switch (this.state) {
            case 0: {
                if (this.lastCreateSequceResponseMessageSentTime != 0L && System.currentTimeMillis() - this.lastCreateSequceResponseMessageSentTime <= this.retransmitTime) break;
                this.sendCreateSequenceResponseMessage();
                this.lastCreateSequceResponseMessageSentTime = System.currentTimeMillis();
                break;
            }
            case 1: {
                this.retransmitSequenceAcknowledgment();
                break;
            }
            case 2: {
                this.retransmitSequenceAcknowledgment();
                break;
            }
            case 3: {
                this.retransmitSequenceAcknowledgment();
            }
        }
    }

    public void sendCreateSequenceResponseMessage() throws AxisFault, RMMessageBuildingException {
        if (this.createSequenceMessageContext != null) {
            CreateSequenceResponseMessage createSequenceResponseMessage = new CreateSequenceResponseMessage();
            createSequenceResponseMessage.setIdentifier(this.sequenceID);
            createSequenceResponseMessage.setSoapNamesapce(this.createSequenceMessageContext.getEnvelope().getNamespace().getNamespaceURI());
            if (this.selfAcksToEPR != null) {
                Accept accept = new Accept();
                accept.setAcceptERP(this.selfAcksToEPR);
                createSequenceResponseMessage.setAccept(accept);
            }
            MessageContext messageContext = MessageContextBuilder.createOutMessageContext((MessageContext)this.createSequenceMessageContext);
            messageContext.setProperty("processRMControlMessage", (Object)"true");
            messageContext.setEnvelope(createSequenceResponseMessage.toSOAPEnvelope());
            messageContext.setTo(this.acksTo);
            messageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse");
            this.sendMessage(messageContext, false);
        }
    }

    private void sendMessage(MessageContext messageContext, boolean isResume) {
        MessageWorker messageWorker = new MessageWorker(messageContext, isResume);
        if (this.isAnonymous) {
            messageWorker.run();
        } else {
            messageContext.getConfigurationContext().getThreadPool().execute((Runnable)messageWorker);
        }
    }

    public synchronized boolean applicationMessageReceived(long messageNumber, MercuryMessageContext mercuryMessageContext) throws PersistenceException {
        this.lastAccesedTime = System.currentTimeMillis();
        int currentState = this.state;
        boolean newMessageReceived = false;
        if (!this.receivedMessageNumbers.contains(new Long(messageNumber))) {
            this.receivedMessageNumbers.add(new Long(messageNumber));
            newMessageReceived = true;
        }
        switch (this.state) {
            case 0: {
                this.state = 1;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.isAllMessagesReceived()) break;
                this.state = 3;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
            }
        }
        try {
            this.invokerBuffer.applicatinMessageReceived(messageNumber, mercuryMessageContext, this.persistanceDto);
        }
        catch (PersistenceException e) {
            this.state = currentState;
            this.persistanceDto.setState(currentState);
            if (newMessageReceived) {
                this.receivedMessageNumbers.remove(new Long(messageNumber));
            }
            log.error((Object)"Can not save the new message to persistence", (Throwable)e);
            throw new PersistenceException("Can not save the new message to persistence", e);
        }
        return newMessageReceived;
    }

    public synchronized boolean lastMessageReceived(long messageNumber, MercuryMessageContext mercuryMessageContext) throws PersistenceException {
        this.lastAccesedTime = System.currentTimeMillis();
        boolean isLastMessageSet = false;
        if (this.lastMessageNumber > 0L) {
            isLastMessageSet = true;
        }
        this.lastMessageNumber = messageNumber;
        if (this.persistanceDto != null) {
            this.persistanceDto.setLastMessageNumber(this.lastMessageNumber);
        }
        int currentState = this.state;
        boolean newMessageReceived = false;
        if (!this.receivedMessageNumbers.contains(new Long(messageNumber))) {
            newMessageReceived = true;
            this.receivedMessageNumbers.add(new Long(messageNumber));
        }
        switch (this.state) {
            case 0: {
                this.state = this.isAllMessagesReceived() ? 3 : 2;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 1: {
                this.state = this.isAllMessagesReceived() ? 3 : 2;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
        }
        try {
            this.invokerBuffer.lastMessageReceived(messageNumber, mercuryMessageContext, this.persistanceDto);
        }
        catch (PersistenceException e) {
            this.state = currentState;
            this.persistanceDto.setState(this.state);
            if (!isLastMessageSet) {
                this.lastMessageNumber = 0L;
                this.persistanceDto.setLastMessageNumber(0L);
            }
            if (newMessageReceived) {
                this.receivedMessageNumbers.remove(new Long(messageNumber));
            }
            log.error((Object)"can not save the receced last message", (Throwable)e);
            throw new PersistenceException("can not save the receced last message", e);
        }
        return newMessageReceived;
    }

    private boolean isAllMessagesReceived() {
        boolean isComplete = false;
        if (this.lastMessageNumber > 0L) {
            isComplete = (long)this.receivedMessageNumbers.size() == this.lastMessageNumber;
        }
        return isComplete;
    }

    private void retransmitSequenceAcknowledgment() throws AxisFault, RMMessageBuildingException {
        if (this.lastAcknowledgmentSentTime == 0L || System.currentTimeMillis() - this.lastAcknowledgmentSentTime > this.retransmitTime) {
            this.sendSequenceAcknowledgementMessage(null);
            this.lastAcknowledgmentSentTime = System.currentTimeMillis();
        }
    }

    public void sendSequenceAcknowledgementMessage(MessageContext inboundMessageContext) throws AxisFault, RMMessageBuildingException {
        if (this.receivedMessageNumbers.size() > 0) {
            SequenceAcknowledgment sequenceAcknowledgment = new SequenceAcknowledgment(this.sequenceID);
            sequenceAcknowledgment.populateAcknowledgmentRanges(this.receivedMessageNumbers);
            sequenceAcknowledgment.setSoapNamesapce(this.getAxis2Info().getSoapNamespaceURI());
            SequenceAcknowledgmentMessage sequenceAcknowledgmentMessage = new SequenceAcknowledgmentMessage(sequenceAcknowledgment);
            sequenceAcknowledgmentMessage.setSoapNamesapce(this.getAxis2Info().getSoapNamespaceURI());
            MessageContext messageContext = this.getNewMessageContext(sequenceAcknowledgmentMessage, inboundMessageContext);
            messageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement");
            AxisService axisServce = this.axis2Info.getAxisService();
            AxisOperation inOnlyOperation = axisServce.getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement");
            OperationContext operationContext = this.axis2Info.getServiceContext().createOperationContext(inOnlyOperation);
            inOnlyOperation.registerOperationContext(messageContext, operationContext);
            messageContext.setAxisMessage(inOnlyOperation.getMessage("In"));
            messageContext.setProperty("messageType", this.axis2Info.getProperty("messageType"));
            this.sendMessage(messageContext, false);
        }
    }

    public synchronized SequenceAcknowledgment getSequenceAcknowledgment() {
        SequenceAcknowledgment sequenceAcknowledgment = new SequenceAcknowledgment(this.sequenceID);
        sequenceAcknowledgment.populateAcknowledgmentRanges(this.receivedMessageNumbers);
        sequenceAcknowledgment.setSoapNamesapce(this.axis2Info.getSoapNamespaceURI());
        return sequenceAcknowledgment;
    }

    private MessageContext getNewMessageContext(SequenceAcknowledgmentMessage sequenceAcknowledgmentMessage, MessageContext inboundMessageContext) throws AxisFault, RMMessageBuildingException {
        MessageContext messageContext = new MessageContext();
        messageContext.setServiceContext(this.axis2Info.getServiceContext());
        messageContext.setEnvelope(sequenceAcknowledgmentMessage.toSOAPEnvelope());
        messageContext.setMessageID(UUIDGenerator.getUUID());
        messageContext.setProperty("processRMControlMessage", (Object)"true");
        if (inboundMessageContext == null) {
            messageContext.setTransportOut(this.axis2Info.getTransportOut());
            messageContext.getOptions().setTo(this.acksTo);
        } else {
            messageContext.setTransportOut(inboundMessageContext.getTransportOut());
            messageContext.setProperty("TRANSPORT_OUT", inboundMessageContext.getProperty("TRANSPORT_OUT"));
            messageContext.setProperty("OutTransportInfo", inboundMessageContext.getProperty("OutTransportInfo"));
            messageContext.setProperty("RequestResponseTransportControl", inboundMessageContext.getProperty("RequestResponseTransportControl"));
        }
        return messageContext;
    }

    public synchronized void terminateSequenceMessageReceived() throws PersistenceException {
        this.lastAccesedTime = System.currentTimeMillis();
        int currentState = this.state;
        switch (this.state) {
            case 0: {
                this.state = 4;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 1: {
                this.state = 4;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 2: {
                this.state = 4;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 3: {
                this.state = 4;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
            }
        }
        try {
            if (this.persistanceDto != null) {
                this.persistanceDto.setEndTime(System.currentTimeMillis());
            }
            this.invokerBuffer.terminateMessageReceived(this.persistanceDto);
        }
        catch (PersistenceException e) {
            this.state = currentState;
            this.persistanceDto.setState(currentState);
            log.error((Object)"Can not update the persistence state", (Throwable)e);
            throw new PersistenceException("Can not update the persistence state", e);
        }
    }

    public void save() throws PersistenceException {
        PersistenceManager persistenceManager = this.getPersistanceManager();
        if (persistenceManager != null) {
            this.persistanceDto = new RMDSequenceDto();
            this.persistanceDto.setSequenceID(this.sequenceID);
            this.persistanceDto.setState(this.state);
            this.persistanceDto.setAcksTo(this.acksTo.getAddress());
            this.persistanceDto.setLastMessageNumber(this.lastMessageNumber);
            this.persistanceDto.setStartTime(System.currentTimeMillis());
            this.invokerBuffer.save(this.persistanceDto);
        }
    }

    public void loadRMDSequenceDetails(MessageContext messageContext) throws PersistenceException, AxisFault {
        PersistenceManager persistenceManager = this.getPersistanceManager();
        List sequenceReceivedNumbers = persistenceManager.getSequenceReceivedNumbersWithRMDSequenceID(this.persistanceDto.getId());
        for (SequenceReceivedNumberDto sequenceReceivedNumberDto : sequenceReceivedNumbers) {
            this.receivedMessageNumbers.add(new Long(sequenceReceivedNumberDto.getNumber()));
            MessageReceiver messageReceiver = messageContext.getAxisOperation().getMessageReceiver();
            if (!(messageReceiver instanceof CallbackReceiver)) continue;
            CallbackReceiver callbackReceiver = (CallbackReceiver)messageReceiver;
            callbackReceiver.getCallbackStore().remove(sequenceReceivedNumberDto.getRelatesToMessageID());
        }
        InvokerBufferDto invokerBufferDto = persistenceManager.getInvokerBufferWithRMDSequenceID(this.persistanceDto.getId());
        this.invokerBuffer.setState(invokerBufferDto.getState());
        this.invokerBuffer.setLastMessageNumber(invokerBufferDto.getLastMessage());
        this.invokerBuffer.setLastMessageSendToApplication(invokerBufferDto.getLastMessageToApplication());
        this.invokerBuffer.setPersistanceDto(invokerBufferDto);
        this.invokerBuffer.loadInvokerBufferDetails(messageContext);
    }

    private PersistenceManager getPersistanceManager() {
        PersistenceManager persistenceManager = null;
        if (this.axis2Info.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
            persistenceManager = (PersistenceManager)this.axis2Info.getConfigurationContext().getProperty("rmPersistanceManager");
        }
        return persistenceManager;
    }

    public synchronized void terminate() {
        this.state = 4;
        this.invokerBuffer.terminate();
    }

    public synchronized boolean isMessageReceived(long messageNumber) {
        return this.receivedMessageNumbers.contains(new Long(messageNumber));
    }

    public synchronized int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public synchronized long getLastAccesedTime() {
        return this.lastAccesedTime;
    }

    public void setLastAccesedTime(long lastAccesedTime) {
        this.lastAccesedTime = lastAccesedTime;
    }

    public EndpointReference getAcksTo() {
        return this.acksTo;
    }

    public void setAcksTo(EndpointReference acksTo) {
        this.acksTo = acksTo;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(String sequenceID) {
        this.sequenceID = sequenceID;
    }

    public MessageContext getCreateSequenceMessageContext() {
        return this.createSequenceMessageContext;
    }

    public void setCreateSequenceMessageContext(MessageContext createSequenceMessageContext) {
        this.createSequenceMessageContext = createSequenceMessageContext;
    }

    public InvokerBuffer getInvokerBuffer() {
        return this.invokerBuffer;
    }

    public void setInvokerBuffer(InvokerBuffer invokerBuffer) {
        this.invokerBuffer = invokerBuffer;
    }

    public Axis2Info getAxis2Info() {
        return this.axis2Info;
    }

    public void setAxis2Info(Axis2Info axis2Info) {
        this.axis2Info = axis2Info;
    }

    public long getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public void setLastMessageNumber(long lastMessageNumber) {
        this.lastMessageNumber = lastMessageNumber;
    }

    public RMDSequenceDto getPersistanceDto() {
        return this.persistanceDto;
    }

    public void setPersistanceDto(RMDSequenceDto persistanceDto) {
        this.persistanceDto = persistanceDto;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.isAnonymous = anonymous;
    }

    public RMSSequence getOfferedRMSSequence() {
        return this.offeredRMSSequence;
    }

    public void setOfferedRMSSequence(RMSSequence offeredRMSSequence) {
        this.offeredRMSSequence = offeredRMSSequence;
    }

    public String getSelfAcksToEPR() {
        return this.selfAcksToEPR;
    }

    public void setSelfAcksToEPR(String selfAcksToEPR) {
        this.selfAcksToEPR = selfAcksToEPR;
    }

    public long getRetransmitTime() {
        return this.retransmitTime;
    }

    public void setRetransmitTime(long retransmitTime) {
        this.retransmitTime = retransmitTime;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.timeoutTime = timeoutTime;
    }
}

