/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.keys.InternalSequenceKey;
import org.wso2.mercury.message.CreateSequenceMessage;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.persistence.dto.InternalKeyDto;
import org.wso2.mercury.persistence.dto.RMDSequenceDto;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.state.Axis2Info;
import org.wso2.mercury.state.RMDSequence;
import org.wso2.mercury.state.RMSContext;
import org.wso2.mercury.state.RMSSequence;
import org.wso2.mercury.util.MercuryParameterHandler;
import org.wso2.mercury.util.RMUtil;
import org.wso2.mercury.workers.InvokerWorker;
import org.wso2.mercury.workers.RMDSequenceWorker;
import org.wso2.mercury.workers.RMSSequenceWorker;

public class RMDContext {
    private static Log log = LogFactory.getLog(RMDContext.class);
    private Map sequenceIDRMDSequenceMap = new HashMap();
    private ConfigurationContext configurationContext;

    public RMDContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public synchronized RMDSequence processCreateSequenceRequest(MessageContext messageContext) throws RMMessageBuildingException, AxisFault {
        CreateSequenceMessage createSequenceMessage = CreateSequenceMessage.fromSOAPEnvelope(messageContext.getEnvelope());
        String sequenceID = RMUtil.getUUID();
        RMDSequence rmdSequence = new RMDSequence(0);
        rmdSequence.setAcksTo(new EndpointReference(createSequenceMessage.getAcksToAddress()));
        rmdSequence.getInvokerBuffer().setAcksTo(new EndpointReference(createSequenceMessage.getAcksToAddress()));
        rmdSequence.setSequenceID(sequenceID);
        rmdSequence.setCreateSequenceMessageContext(messageContext);
        Axis2Info axis2Info = this.getAxis2Info(messageContext, createSequenceMessage.getAcksToAddress(), createSequenceMessage.getAddressingNamespace());
        rmdSequence.setAxis2Info(axis2Info);
        rmdSequence.setInvokerBufferPersistanceManager();
        MercuryParameterHandler mercuryParameterHandler = new MercuryParameterHandler((AxisDescription)messageContext.getAxisService());
        rmdSequence.setRetransmitTime(mercuryParameterHandler.getRMDSequenceRetransmitTime());
        rmdSequence.setTimeoutTime(mercuryParameterHandler.getRMDSequenceTimeout());
        rmdSequence.getInvokerBuffer().setTimeoutTime(mercuryParameterHandler.getInvokerTimeout());
        if (messageContext.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
            try {
                rmdSequence.save();
            }
            catch (PersistenceException e) {
                log.error((Object)"Can not save to data base");
            }
        }
        this.registerRMDSequenceToSequenceID(sequenceID, rmdSequence);
        String acksToAddress = createSequenceMessage.getAcksToAddress();
        if (createSequenceMessage.getOfferIdentifier() != null && messageContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/in-out")) {
            rmdSequence.setSelfAcksToEPR(messageContext.getOptions().getTo().getAddress());
            RMSSequence rmsSequence = new RMSSequence(4, new EndpointReference(createSequenceMessage.getAcksToAddress()));
            axis2Info = this.getAxis2Info(messageContext, createSequenceMessage.getAcksToAddress(), createSequenceMessage.getAddressingNamespace());
            axis2Info.getOptions().setTo(new EndpointReference(createSequenceMessage.getAcksToAddress()));
            rmsSequence.setAxis2Info(axis2Info);
            rmsSequence.setSequenceID(createSequenceMessage.getOfferIdentifier());
            rmsSequence.setRetransmitTime(mercuryParameterHandler.getRMSSequenceRetransmitTime());
            rmsSequence.setTimeoutTime(mercuryParameterHandler.getRMSSequenceTimeout());
            rmsSequence.setMaximumRetrasmitCount(mercuryParameterHandler.getRMSMaximumRetransmitCount());
            InternalSequenceKey key = new InternalSequenceKey(createSequenceMessage.getAcksToAddress(), sequenceID);
            if (messageContext.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
                PersistenceManager persistenceManager = (PersistenceManager)messageContext.getConfigurationContext().getProperty("rmPersistanceManager");
                InternalKeyDto internalKeyDto = new InternalKeyDto(key.getInternalKey(), key.getEndPointAddress());
                try {
                    persistenceManager.save(internalKeyDto);
                    rmsSequence.save(internalKeyDto.getId());
                }
                catch (PersistenceException e) {
                    log.error((Object)"Can not persists objects", (Throwable)e);
                    throw new AxisFault("Can not persists objects", (Throwable)e);
                }
            }
            RMSContext rmsContext = (RMSContext)this.configurationContext.getProperty("MercuryRMSContext");
            rmsContext.registerRMSSequenceToInternalKey(key, rmsSequence);
            rmsContext.registerRMSSequenceToSequenceID(createSequenceMessage.getOfferIdentifier(), rmsSequence);
            if (acksToAddress.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous") || acksToAddress.equals("http://www.w3.org/2005/08/addressing/anonymous")) {
                rmsSequence.setAnnonymous(true);
                rmdSequence.setOfferedRMSSequence(rmsSequence);
                rmsSequence.setOfferedRMDSequence(rmdSequence);
            } else {
                rmsSequence.setAnnonymous(false);
                RMSSequenceWorker rmsSequenceWorker = new RMSSequenceWorker(rmsSequence);
                rmsSequenceWorker.setSequenceWorkerSleepTime(mercuryParameterHandler.getRMSSequenceWorkerSleepTime());
                this.configurationContext.getThreadPool().execute((Runnable)rmsSequenceWorker);
            }
        }
        InvokerWorker invokerWorker = new InvokerWorker(rmdSequence.getInvokerBuffer());
        invokerWorker.setSleepTime(mercuryParameterHandler.getInvokerSleepTime());
        this.configurationContext.getThreadPool().execute((Runnable)invokerWorker);
        if (acksToAddress.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous") || acksToAddress.equals("http://www.w3.org/2005/08/addressing/anonymous")) {
            rmdSequence.setAnonymous(true);
            rmdSequence.getInvokerBuffer().setAnonymous(true);
        } else {
            rmdSequence.setAnonymous(false);
            rmdSequence.getInvokerBuffer().setAnonymous(false);
            RMDSequenceWorker rmdSequenceWorker = new RMDSequenceWorker(rmdSequence);
            rmdSequenceWorker.setSequenceWorkerSleepTime(mercuryParameterHandler.getRMDSequenceWorkerSleepTime());
            this.configurationContext.getThreadPool().execute((Runnable)rmdSequenceWorker);
        }
        return rmdSequence;
    }

    public synchronized void loadRMDSequenceFromPersistanceStorage(String sequenceID, MessageContext messageContext) throws PersistenceException, AxisFault {
        PersistenceManager persistenceManager = (PersistenceManager)messageContext.getConfigurationContext().getProperty("rmPersistanceManager");
        RMDSequenceDto rmdSequenceDto = persistenceManager.getRMDSequeceWithSequenceID(sequenceID);
        RMDSequence rmdSequence = new RMDSequence(rmdSequenceDto.getState());
        rmdSequence.setSequenceID(rmdSequenceDto.getSequenceID());
        rmdSequence.setAcksTo(new EndpointReference(rmdSequenceDto.getAcksTo()));
        rmdSequence.setLastMessageNumber(rmdSequenceDto.getLastMessageNumber());
        rmdSequence.setPersistanceDto(rmdSequenceDto);
        Axis2Info axis2Info = this.getAxis2Info(messageContext, rmdSequenceDto.getAcksTo(), null);
        rmdSequence.setAxis2Info(axis2Info);
        rmdSequence.setInvokerBufferPersistanceManager();
        rmdSequence.loadRMDSequenceDetails(messageContext);
        MercuryParameterHandler mercuryParameterHandler = new MercuryParameterHandler((AxisDescription)messageContext.getAxisService());
        rmdSequence.setRetransmitTime(mercuryParameterHandler.getRMDSequenceRetransmitTime());
        rmdSequence.setTimeoutTime(mercuryParameterHandler.getRMDSequenceTimeout());
        rmdSequence.getInvokerBuffer().setTimeoutTime(mercuryParameterHandler.getInvokerTimeout());
        this.registerRMDSequenceToSequenceID(rmdSequence.getSequenceID(), rmdSequence);
        RMDSequenceWorker rmdSequenceWorker = new RMDSequenceWorker(rmdSequence);
        rmdSequenceWorker.setSequenceWorkerSleepTime(mercuryParameterHandler.getRMDSequenceWorkerSleepTime());
        this.configurationContext.getThreadPool().execute((Runnable)rmdSequenceWorker);
        InvokerWorker invokerWorker = new InvokerWorker(rmdSequence.getInvokerBuffer());
        invokerWorker.setSleepTime(mercuryParameterHandler.getInvokerSleepTime());
        this.configurationContext.getThreadPool().execute((Runnable)invokerWorker);
    }

    private Axis2Info getAxis2Info(MessageContext messageContext, String acksToAddress, String addressingNamespaceURI) throws AxisFault {
        Axis2Info axis2Info = new Axis2Info();
        axis2Info.setServiceContext(messageContext.getServiceContext());
        axis2Info.setOptions(messageContext.getOptions());
        axis2Info.setTransportIn(messageContext.getTransportIn());
        TransportOutDescription transportOut = ClientUtils.inferOutTransport((AxisConfiguration)messageContext.getConfigurationContext().getAxisConfiguration(), (EndpointReference)new EndpointReference(acksToAddress), (MessageContext)messageContext);
        axis2Info.setTransportOut(transportOut);
        axis2Info.setServerSide(messageContext.isServerSide());
        axis2Info.setSoapNamespaceURI(messageContext.getEnvelope().getNamespace().getNamespaceURI());
        axis2Info.setAddressingNamespaceURI(addressingNamespaceURI);
        axis2Info.setProperties(messageContext.getProperties());
        return axis2Info;
    }

    public synchronized RMDSequence createRMDSequenceWithOffer(String offerID, String acksToAddress, Axis2Info axis2Info, boolean isAnonymous) {
        RMDSequence rmdSequence = new RMDSequence(1);
        rmdSequence.setAcksTo(new EndpointReference(acksToAddress));
        rmdSequence.setSequenceID(offerID);
        rmdSequence.setAxis2Info(axis2Info);
        rmdSequence.setAnonymous(isAnonymous);
        rmdSequence.getInvokerBuffer().setAnonymous(isAnonymous);
        rmdSequence.setInvokerBufferPersistanceManager();
        MercuryParameterHandler mercuryParameterHandler = new MercuryParameterHandler((AxisDescription)axis2Info.getAxisService());
        rmdSequence.setRetransmitTime(mercuryParameterHandler.getRMDSequenceRetransmitTime());
        rmdSequence.setTimeoutTime(mercuryParameterHandler.getRMDSequenceTimeout());
        rmdSequence.getInvokerBuffer().setTimeoutTime(mercuryParameterHandler.getInvokerTimeout());
        this.registerRMDSequenceToSequenceID(offerID, rmdSequence);
        if (axis2Info.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
            try {
                rmdSequence.save();
            }
            catch (PersistenceException e) {
                log.error((Object)"Can not save to data base");
            }
        }
        if (!isAnonymous) {
            RMDSequenceWorker rmdSequenceWorker = new RMDSequenceWorker(rmdSequence);
            rmdSequenceWorker.setSequenceWorkerSleepTime(mercuryParameterHandler.getRMDSequenceWorkerSleepTime());
            this.configurationContext.getThreadPool().execute((Runnable)rmdSequenceWorker);
        }
        InvokerWorker invokerWorker = new InvokerWorker(rmdSequence.getInvokerBuffer());
        invokerWorker.setSleepTime(mercuryParameterHandler.getInvokerSleepTime());
        this.configurationContext.getThreadPool().execute((Runnable)invokerWorker);
        return rmdSequence;
    }

    public synchronized void removeExpiredSequences() {
        ArrayList<String> expiredSequences = new ArrayList<String>();
        String sequenceID2 = null;
        RMDSequence rmdSequence = null;
        for (String sequenceID2 : this.sequenceIDRMDSequenceMap.keySet()) {
            rmdSequence = (RMDSequence)this.sequenceIDRMDSequenceMap.get(sequenceID2);
            if (rmdSequence.getState() != 4 && System.currentTimeMillis() - rmdSequence.getLastAccesedTime() <= rmdSequence.getTimeoutTime()) continue;
            expiredSequences.add(sequenceID2);
        }
        for (String sequenceID2 : expiredSequences) {
            log.info((Object)("Removing the sequence " + sequenceID2 + " from the RMDContext "));
            this.sequenceIDRMDSequenceMap.remove(sequenceID2);
        }
    }

    public void registerRMDSequenceToSequenceID(String sequenceID, RMDSequence rmdSequence) {
        this.sequenceIDRMDSequenceMap.put(sequenceID, rmdSequence);
    }

    public synchronized RMDSequence getRMDSeqenceWithSequenceID(String sequenceID) {
        return (RMDSequence)this.sequenceIDRMDSequenceMap.get(sequenceID);
    }

    public void unRegisterRMDSequenceWithSequenceID(String sequenceID) {
        this.sequenceIDRMDSequenceMap.remove(sequenceID);
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

