/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.state;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.context.MercuryMessageContext;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMApplicationMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.persistence.dto.BufferReceivedNumberDto;
import org.wso2.mercury.persistence.dto.InvokerBufferDto;
import org.wso2.mercury.persistence.dto.RMDMessageDto;
import org.wso2.mercury.persistence.dto.RMDSequenceDto;
import org.wso2.mercury.persistence.dto.SequenceReceivedNumberDto;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.workers.InvokerWorker;

public class InvokerBuffer {
    private static Log log = LogFactory.getLog(InvokerBuffer.class);
    public static final int STATE_000 = 1;
    public static final int STATE_010 = 2;
    public static final int STATE_011 = 3;
    public static final int STATE_111 = 4;
    public static final int STATE_110 = 5;
    public static final int STATE_COMPLETE = 6;
    private int state;
    private long timeoutTime;
    private Map messageBuffer;
    private Set receivedMessageNumbers;
    private long lastMessageNumber = 0L;
    private long lastAccessTime = 0L;
    private long lastMessageSendToApplication = 0L;
    private InvokerBufferDto persistanceDto;
    private PersistenceManager persistenceManager;
    private boolean isAnonymous;
    private EndpointReference acksTo;
    private InvokerWorker invokerWorker;

    public InvokerBuffer(int state) {
        this.state = state;
        this.messageBuffer = new HashMap();
        this.receivedMessageNumbers = new HashSet();
        this.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized void applicatinMessageReceived(long messageNumber, MercuryMessageContext mercuryMessageContext, RMDSequenceDto rmdSequenceDto) throws PersistenceException {
        this.lastAccessTime = System.currentTimeMillis();
        if (!this.receivedMessageNumbers.contains(new Long(messageNumber))) {
            int currentState = this.state;
            switch (this.state) {
                case 1: {
                    this.state = 2;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (this.persistenceManager != null) {
                SequenceReceivedNumberDto sequenceReceivedNumberDto = new SequenceReceivedNumberDto();
                sequenceReceivedNumberDto.setNumber(messageNumber);
                sequenceReceivedNumberDto.setRmdSequenceID(rmdSequenceDto.getId());
                if (mercuryMessageContext.getMessageContext().getRelatesTo() != null) {
                    sequenceReceivedNumberDto.setRelatesToMessageID(mercuryMessageContext.getMessageContext().getRelatesTo().getValue());
                }
                BufferReceivedNumberDto bufferReceivedNumberDto = new BufferReceivedNumberDto();
                bufferReceivedNumberDto.setNumber(messageNumber);
                bufferReceivedNumberDto.setInternalBufferID(this.persistanceDto.getId());
                RMDMessageDto rmdMessageDto = new RMDMessageDto();
                rmdMessageDto.setMessageNumber(messageNumber);
                rmdMessageDto.setSoapEnvelope(mercuryMessageContext.getMessageContext().getEnvelope().toString());
                rmdMessageDto.setSend(false);
                rmdMessageDto.setInternalBufferID(this.persistanceDto.getId());
                try {
                    this.persistenceManager.updateMessageDetails(rmdSequenceDto, this.persistanceDto, sequenceReceivedNumberDto, bufferReceivedNumberDto, rmdMessageDto);
                    mercuryMessageContext.setRmdPersistanceDto(rmdMessageDto);
                }
                catch (PersistenceException e) {
                    e.printStackTrace();
                    this.state = currentState;
                    this.persistanceDto.setState(currentState);
                    log.error((Object)("Can not update the persistence manager for message with message number ==> " + messageNumber), (Throwable)e);
                    throw new PersistenceException("Can not update the persistence manager for message with message number ==> " + messageNumber, e);
                }
            }
            this.messageBuffer.put(new Long(messageNumber), mercuryMessageContext);
            this.receivedMessageNumbers.add(new Long(messageNumber));
        }
    }

    public synchronized void lastMessageReceived(long messageNumber, MercuryMessageContext mercuryMessageContext, RMDSequenceDto rmdSequenceDto) throws PersistenceException {
        this.lastAccessTime = System.currentTimeMillis();
        if (!this.receivedMessageNumbers.contains(new Long(messageNumber))) {
            int currentState = this.state;
            switch (this.state) {
                case 1: {
                    this.state = 5;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
                case 2: {
                    this.state = 5;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (this.persistenceManager != null) {
                SequenceReceivedNumberDto sequenceReceivedNumberDto = new SequenceReceivedNumberDto();
                sequenceReceivedNumberDto.setNumber(messageNumber);
                sequenceReceivedNumberDto.setRmdSequenceID(rmdSequenceDto.getId());
                BufferReceivedNumberDto bufferReceivedNumberDto = new BufferReceivedNumberDto();
                bufferReceivedNumberDto.setNumber(messageNumber);
                bufferReceivedNumberDto.setInternalBufferID(this.persistanceDto.getId());
                RMDMessageDto rmdMessageDto = new RMDMessageDto();
                rmdMessageDto.setMessageNumber(messageNumber);
                rmdMessageDto.setSoapEnvelope(mercuryMessageContext.getMessageContext().getEnvelope().toString());
                rmdMessageDto.setSend(false);
                rmdMessageDto.setInternalBufferID(this.persistanceDto.getId());
                this.persistanceDto.setLastMessage(messageNumber);
                try {
                    this.persistenceManager.updateMessageDetails(rmdSequenceDto, this.persistanceDto, sequenceReceivedNumberDto, bufferReceivedNumberDto, rmdMessageDto);
                    mercuryMessageContext.setRmdPersistanceDto(rmdMessageDto);
                }
                catch (PersistenceException e) {
                    this.state = currentState;
                    this.persistanceDto.setState(currentState);
                    this.persistanceDto.setLastMessage(0L);
                    log.error((Object)("Can not update the persistence manager for message with message number ==> " + messageNumber), (Throwable)e);
                    throw new PersistenceException("Can not update the persistence manager for message with message number ==> " + messageNumber, e);
                }
            }
            this.lastMessageNumber = messageNumber;
            this.messageBuffer.put(new Long(messageNumber), mercuryMessageContext);
            this.receivedMessageNumbers.add(new Long(messageNumber));
        }
    }

    public boolean isMessagesCompleted() {
        return this.lastMessageNumber != 0L && (long)this.receivedMessageNumbers.size() == this.lastMessageNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doActions() throws AxisFault {
        while (this.messageBuffer.keySet().contains(new Long(this.lastMessageSendToApplication + 1L))) {
            ++this.lastMessageSendToApplication;
            log.debug((Object)("Sending application message " + this.lastMessageSendToApplication + " to application"));
            MercuryMessageContext mercuryMessageContext = (MercuryMessageContext)this.messageBuffer.remove(new Long(this.lastMessageSendToApplication));
            int currentState = this.state;
            switch (this.state) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.messageBuffer.size() != 0) break;
                    this.state = 1;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
                case 3: {
                    if (this.messageBuffer.size() != 0) break;
                    this.state = 6;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
                case 4: {
                    if (this.messageBuffer.size() != 0) break;
                    this.state = 6;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
                case 5: {
                    if (this.messageBuffer.size() != 0) break;
                    this.state = 6;
                    if (this.persistanceDto == null) break;
                    this.persistanceDto.setState(this.state);
                    break;
                }
            }
            if (this.persistenceManager != null) {
                try {
                    this.persistanceDto.setLastMessageToApplication(this.lastMessageSendToApplication);
                    mercuryMessageContext.getRmdPersistanceDto().setSend(true);
                    this.persistenceManager.update(mercuryMessageContext.getRmdPersistanceDto(), this.persistanceDto);
                }
                catch (PersistenceException e) {
                    this.state = currentState;
                    this.persistanceDto.setState(this.state);
                    this.messageBuffer.put(new Long(this.lastMessageSendToApplication), mercuryMessageContext);
                    mercuryMessageContext.getRmdPersistanceDto().setSend(false);
                    --this.lastMessageSendToApplication;
                    log.error((Object)"Problem when updating the data base to send the message to application", (Throwable)e);
                    break;
                }
            }
            mercuryMessageContext.getMessageContext().setProperty("processRMControlMessage", (Object)"true");
            if (this.isAnonymous && !mercuryMessageContext.getMessageContext().isServerSide()) {
                this.notifyAll();
                continue;
            }
            try {
                Object applicationMsgContext = mercuryMessageContext.getMessageContext();
                if (!applicationMsgContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage")) {
                    AxisEngine.resumeReceive((MessageContext)mercuryMessageContext.getMessageContext());
                    continue;
                }
                String sessionID = mercuryMessageContext.getRmApplicationMessage().getSequence().getSequenceID();
                MessageContext outMessageContext = this.getNewMessageContextForLastMessage((MessageContext)applicationMsgContext, sessionID);
                outMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
                outMessageContext.setProperty("MercuryInternalKey", applicationMsgContext.getProperty("SessionID"));
                outMessageContext.setProperty("MercuryLastMessage", (Object)"true");
                AxisOperation axisOperation = applicationMsgContext.getAxisService().getOperationByAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
                outMessageContext.setAxisMessage(axisOperation.getMessage("In"));
                OperationContext operationContext = applicationMsgContext.getServiceContext().createOperationContext(axisOperation);
                axisOperation.registerOperationContext(outMessageContext, operationContext);
                AxisEngine.send((MessageContext)outMessageContext);
            }
            catch (AxisFault e) {
                if (e.getFaultType() == 1) {
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mercuryMessageContext.getMessageContext(), (Throwable)e);
                    AxisOperation axisOperation = mercuryMessageContext.getMessageContext().getAxisOperation();
                    if (axisOperation.getMessage("Out") != null) {
                        faultContext.setAxisMessage(axisOperation.getMessage("Out"));
                    } else {
                        faultContext.setAxisMessage(axisOperation.getMessage("In"));
                    }
                    faultContext.setProperty("RECV_RESULTS", mercuryMessageContext.getMessageContext().getProperty("RECV_RESULTS"));
                    faultContext.setProperty("applicationFault", (Object)"true");
                    faultContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, mercuryMessageContext.getMessageContext().getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE));
                    AxisFault axisFault = new AxisFault(e.getMessage(), faultContext);
                    axisFault.setDetail(e.getDetail());
                    axisFault.setFaultCode(e.getFaultCode());
                    axisFault.setFaultAction(e.getFaultAction());
                    axisFault.setFaultType(e.getFaultType());
                    throw axisFault;
                }
                log.error((Object)"Non application type fault occurs when sending the message to application ", (Throwable)e);
            }
            finally {
                if (!mercuryMessageContext.getMessageContext().isServerSide() || this.isAnonymous && !mercuryMessageContext.getMessageContext().getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/in-only")) continue;
                MercuryMessageContext mercuryMessageContext2 = mercuryMessageContext;
                synchronized (mercuryMessageContext2) {
                    mercuryMessageContext.notify();
                }
            }
        }
    }

    private MessageContext getNewMessageContextForLastMessage(MessageContext inMessageContext, String sessionID) throws AxisFault {
        MessageContext messageContext = new MessageContext();
        messageContext.setServiceContext(inMessageContext.getServiceContext());
        String soapNamespace = inMessageContext.getEnvelope().getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        soapFactory = soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        messageContext.getOptions().setSoapVersionURI(soapNamespace);
        messageContext.setEnvelope(soapFactory.getDefaultEnvelope());
        messageContext.setMessageID(UUIDGenerator.getUUID());
        inMessageContext.getOptions().setFrom(null);
        messageContext.setOptions(inMessageContext.getOptions());
        messageContext.setServerSide(inMessageContext.isServerSide());
        messageContext.setProperty("RECV_RESULTS", inMessageContext.getProperty("RECV_RESULTS"));
        messageContext.getOptions().setTo(this.acksTo);
        if (!this.isAnonymous) {
            messageContext.setTransportOut(inMessageContext.getTransportOut());
        } else {
            messageContext.setProperty("messageType", inMessageContext.getProperty("messageType"));
            messageContext.setTransportOut(inMessageContext.getTransportOut());
            messageContext.setProperty("TRANSPORT_OUT", inMessageContext.getProperty("TRANSPORT_OUT"));
            messageContext.setProperty("OutTransportInfo", inMessageContext.getProperty("OutTransportInfo"));
            messageContext.setProperty("RequestResponseTransportControl", inMessageContext.getProperty("RequestResponseTransportControl"));
            messageContext.setProperty("HTTP_HEADERS", inMessageContext.getProperty("HTTP_HEADERS"));
        }
        return messageContext;
    }

    public synchronized void terminateMessageReceived(RMDSequenceDto rmdSequenceDto) throws PersistenceException {
        this.lastAccessTime = System.currentTimeMillis();
        int currentState = this.state;
        switch (this.state) {
            case 1: {
                this.state = 6;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 2: {
                this.state = 3;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.state = 4;
                if (this.persistanceDto == null) break;
                this.persistanceDto.setState(this.state);
                break;
            }
        }
        if (this.persistenceManager != null) {
            try {
                this.persistenceManager.update(this.persistanceDto, rmdSequenceDto);
            }
            catch (PersistenceException e) {
                this.state = currentState;
                this.persistanceDto.setState(currentState);
                log.error((Object)"Can not update the buffer sate", (Throwable)e);
                throw new PersistenceException("Can not update the buffer sate", e);
            }
        }
    }

    public void save(RMDSequenceDto rmdSequenceDto) throws PersistenceException {
        this.persistanceDto = new InvokerBufferDto();
        this.persistanceDto.setState(this.state);
        this.persistanceDto.setLastMessage(this.lastMessageNumber);
        this.persistanceDto.setLastMessageToApplication(this.lastMessageSendToApplication);
        this.persistenceManager.save(this.persistanceDto, rmdSequenceDto);
    }

    public void loadInvokerBufferDetails(MessageContext messageContext) throws PersistenceException, AxisFault {
        List bufferReceivedNumbers = this.persistenceManager.getBufferReceivedNumbersWithInvokerBufferID(this.persistanceDto.getId());
        BufferReceivedNumberDto bufferReceivedNumberDto2 = null;
        for (BufferReceivedNumberDto bufferReceivedNumberDto2 : bufferReceivedNumbers) {
            this.receivedMessageNumbers.add(new Long(bufferReceivedNumberDto2.getNumber()));
        }
        List bufferMessages = this.persistenceManager.getRMDMessagesWithInvokerBufferID(this.persistanceDto.getId());
        RMDMessageDto rmdMessageDto2 = null;
        for (RMDMessageDto rmdMessageDto2 : bufferMessages) {
            MessageContext newMessageContext = new MessageContext();
            newMessageContext.setCurrentHandlerIndex(messageContext.getCurrentHandlerIndex());
            newMessageContext.setCurrentPhaseIndex(messageContext.getCurrentPhaseIndex());
            newMessageContext.setExecutionChain(messageContext.getExecutionChain());
            newMessageContext.setServiceContext(messageContext.getServiceContext());
            newMessageContext.setMessageID(UUIDGenerator.getUUID());
            newMessageContext.setTransportIn(messageContext.getTransportIn());
            newMessageContext.setTransportOut(messageContext.getTransportOut());
            newMessageContext.setTo(messageContext.getTo());
            newMessageContext.setReplyTo(messageContext.getReplyTo());
            newMessageContext.setOptions(new Options());
            newMessageContext.getOptions().setTo(messageContext.getTo());
            newMessageContext.getOptions().setUseSeparateListener(messageContext.getOptions().isUseSeparateListener());
            newMessageContext.getOptions().setAction(messageContext.getOptions().getAction());
            newMessageContext.setServerSide(messageContext.isServerSide());
            AxisOperation inOutOperation = messageContext.getAxisOperation();
            OperationContext operationContext = messageContext.getServiceContext().createOperationContext(inOutOperation);
            inOutOperation.registerOperationContext(newMessageContext, operationContext);
            messageContext.setAxisMessage(inOutOperation.getMessage("In"));
            RMApplicationMessage rmApplicationMessage = new RMApplicationMessage(this.getSoapEnvelope(rmdMessageDto2.getSoapEnvelope()));
            Sequence sequence = new Sequence();
            rmApplicationMessage.setSequence(sequence);
            sequence.setMessageNumber(rmdMessageDto2.getMessageNumber());
            rmApplicationMessage.setSequenceHeaderAdded(true);
            try {
                newMessageContext.setEnvelope(rmApplicationMessage.toSOAPEnvelope());
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)"Can not build the soap envelope", (Throwable)e);
                throw new PersistenceException("Can not build the soap envelope", e);
            }
            MercuryMessageContext mercuryMessageContext = new MercuryMessageContext(rmApplicationMessage, newMessageContext);
            mercuryMessageContext.setRmdPersistanceDto(rmdMessageDto2);
            this.messageBuffer.put(new Long(rmdMessageDto2.getMessageNumber()), mercuryMessageContext);
        }
    }

    private SOAPEnvelope getSoapEnvelope(String soapEnvelpe) throws PersistenceException {
        try {
            XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(soapEnvelpe.getBytes()));
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlReader);
            SOAPEnvelope soapEnvelope = (SOAPEnvelope)builder.getDocumentElement();
            soapEnvelope.build();
            String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
            if (soapEnvelope.getHeader() == null) {
                SOAPFactory soapFactory = null;
                soapFactory = soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
                soapFactory.createSOAPHeader(soapEnvelope);
            }
            return soapEnvelope;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Problem with the stored message", (Throwable)e);
            throw new PersistenceException("Problem with the stored message", e);
        }
    }

    public synchronized void waitUntilMessageInvoke(long messageNumber) {
        if (messageNumber > this.lastMessageSendToApplication) {
            try {
                this.continueWork();
                this.wait();
                this.waitUntilMessageInvoke(messageNumber);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void terminate() {
        this.state = 6;
    }

    public void continueWork() {
        log.debug((Object)"continueWork");
        if (this.invokerWorker != null) {
            this.invokerWorker.wakeUp();
        } else {
            log.debug((Object)"NO Invoker Worker ??? ");
        }
    }

    public synchronized int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Map getMessageBuffer() {
        return this.messageBuffer;
    }

    public void setMessageBuffer(Map messageBuffer) {
        this.messageBuffer = messageBuffer;
    }

    public synchronized long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public PersistenceManager getPersistanceManager() {
        return this.persistenceManager;
    }

    public void setPersistanceManager(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public long getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public void setLastMessageNumber(long lastMessageNumber) {
        this.lastMessageNumber = lastMessageNumber;
    }

    public synchronized long getLastMessageSendToApplication() {
        return this.lastMessageSendToApplication;
    }

    public InvokerBufferDto getPersistanceDto() {
        return this.persistanceDto;
    }

    public void setPersistanceDto(InvokerBufferDto persistanceDto) {
        this.persistanceDto = persistanceDto;
    }

    public void setLastMessageSendToApplication(long lastMessageSendToApplication) {
        this.lastMessageSendToApplication = lastMessageSendToApplication;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.isAnonymous = anonymous;
    }

    public EndpointReference getAcksTo() {
        return this.acksTo;
    }

    public void setAcksTo(EndpointReference acksTo) {
        this.acksTo = acksTo;
    }

    public void setInvokerWorker(InvokerWorker w) {
        this.invokerWorker = w;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.timeoutTime = timeoutTime;
    }
}

