/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.modules;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.state.RMDContext;
import org.wso2.mercury.state.RMSContext;
import org.wso2.mercury.util.RMDispatchInfo;
import org.wso2.mercury.workers.SequenceRemovalWorker;

public class MercuryModule
implements Module {
    private static Log log = LogFactory.getLog(MercuryModule.class);
    private SequenceRemovalWorker sequenceRemovalWorker;

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        AxisConfiguration axiConfiguration = configContext.getAxisConfiguration();
        if (axiConfiguration.getParameter("rmsSequenceTimeout") == null) {
            axiConfiguration.addParameter("rmsSequenceTimeout", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmsSequenceTimeout")));
        }
        if (axiConfiguration.getParameter("rmsSequenceRetransmitTime") == null) {
            axiConfiguration.addParameter("rmsSequenceRetransmitTime", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmsSequenceRetransmitTime")));
        }
        if (axiConfiguration.getParameter("rmsSequenceWorkerSleepTime") == null) {
            axiConfiguration.addParameter("rmsSequenceWorkerSleepTime", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmsSequenceWorkerSleepTime")));
        }
        if (axiConfiguration.getParameter("rmsMaximumRetransmitCount") == null) {
            axiConfiguration.addParameter("rmsMaximumRetransmitCount", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmsMaximumRetransmitCount")));
        }
        if (axiConfiguration.getParameter("rmdSequenceTimeout") == null) {
            axiConfiguration.addParameter("rmdSequenceTimeout", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmdSequenceTimeout")));
        }
        if (axiConfiguration.getParameter("rmdSequenceRetransmitTime") == null) {
            axiConfiguration.addParameter("rmdSequenceRetransmitTime", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmdSequenceRetransmitTime")));
        }
        if (axiConfiguration.getParameter("rmdSequenceWorkerSleepTime") == null) {
            axiConfiguration.addParameter("rmdSequenceWorkerSleepTime", (Object)Utils.getParameterValue((Parameter)module.getParameter("rmdSequenceWorkerSleepTime")));
        }
        if (axiConfiguration.getParameter("invokerTimeout") == null) {
            axiConfiguration.addParameter("invokerTimeout", (Object)Utils.getParameterValue((Parameter)module.getParameter("invokerTimeout")));
        }
        if (axiConfiguration.getParameter("invokerWorkerSleepTime") == null) {
            axiConfiguration.addParameter("invokerWorkerSleepTime", (Object)Utils.getParameterValue((Parameter)module.getParameter("invokerWorkerSleepTime")));
        }
        if (axiConfiguration.getParameter("enforceRM") == null) {
            axiConfiguration.addParameter("enforceRM", (Object)Utils.getParameterValue((Parameter)module.getParameter("enforceRM")));
        }
        long sequenceRemvalWorkerSleepTime = 30000L;
        if (axiConfiguration.getParameter("sequenceRemovalWorkerSleepTime") != null) {
            sequenceRemvalWorkerSleepTime = Long.parseLong((String)axiConfiguration.getParameter("sequenceRemovalWorkerSleepTime").getValue());
        } else if (module.getParameter("sequenceRemovalWorkerSleepTime") != null) {
            sequenceRemvalWorkerSleepTime = Long.parseLong((String)module.getParameter("sequenceRemovalWorkerSleepTime").getValue());
        }
        configContext.setProperty("MercuryRMSContext", (Object)new RMSContext(configContext));
        configContext.setProperty("MercuryRMDContext", (Object)new RMDContext(configContext));
        configContext.setProperty("RMDispatchInfo", (Object)new RMDispatchInfo());
        String persistanceManagerClass = null;
        if (axiConfiguration.getParameter("rmPersistanceManager") != null) {
            persistanceManagerClass = (String)axiConfiguration.getParameter("rmPersistanceManager").getValue();
        } else if (module.getParameter("rmPersistanceManager") != null) {
            persistanceManagerClass = (String)module.getParameter("rmPersistanceManager").getValue();
        }
        if (persistanceManagerClass != null) {
            try {
                PersistenceManager persistenceManager = (PersistenceManager)Class.forName(persistanceManagerClass).newInstance();
                configContext.setProperty("rmPersistanceManager", (Object)persistenceManager);
            }
            catch (InstantiationException e) {
                log.error((Object)"Can not instantiate persistence manager", (Throwable)e);
                throw new AxisFault("Can not instantiate persistence manager", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Illegal Access to persistence manager", (Throwable)e);
                throw new AxisFault("Illegal Access to persistence manager", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Persistance manager class not found", (Throwable)e);
                throw new AxisFault("Persistance manager class not found", (Throwable)e);
            }
        }
        this.sequenceRemovalWorker = new SequenceRemovalWorker(configContext);
        this.sequenceRemovalWorker.setSequenceRemovalWorkerSleepTime(sequenceRemvalWorkerSleepTime);
        configContext.getThreadPool().execute((Runnable)this.sequenceRemovalWorker);
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        log.info((Object)"Shutting down Mecury");
        this.sequenceRemovalWorker.shutDownWorker();
        configurationContext.removeProperty("MercuryRMSContext");
        configurationContext.removeProperty("MercuryRMDContext");
        configurationContext.removeProperty("RMDispatchInfo");
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }
}

