/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMMessage;
import org.wso2.mercury.message.SequenceAcknowledgment;

public class TerminateSequenceMessage
extends RMMessage {
    private String identifier;
    private SequenceAcknowledgment sequenceAcknowledgment;

    public TerminateSequenceMessage() {
    }

    public TerminateSequenceMessage(String rmNamespace, String soapNamesapce) {
        super(rmNamespace, soapNamesapce);
    }

    public TerminateSequenceMessage(String identifier) {
        this.identifier = identifier;
    }

    public SOAPEnvelope toSOAPEnvelope() throws RMMessageBuildingException {
        SOAPFactory soapFactory = this.getSoapFactory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        OMElement terminateSequenceElement = soapFactory.createOMElement("TerminateSequence", this.rmNamespace, "wsrm");
        OMElement identifierElement = soapFactory.createOMElement("Identifier", this.rmNamespace, "wsrm");
        identifierElement.setText(this.identifier);
        terminateSequenceElement.addChild((OMNode)identifierElement);
        soapEnvelope.getBody().addChild((OMNode)terminateSequenceElement);
        if (this.sequenceAcknowledgment != null) {
            soapEnvelope.getHeader().addChild((OMNode)this.sequenceAcknowledgment.toSOAPHeaderBlock());
        }
        return soapEnvelope;
    }

    public static TerminateSequenceMessage fromSOAPEnvelpe(SOAPEnvelope soapEnvelope) throws RMMessageBuildingException {
        String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
        OMElement terminateSequenceElement = soapEnvelope.getBody().getFirstElement();
        String rmNamespace = terminateSequenceElement.getNamespace().getNamespaceURI();
        TerminateSequenceMessage terminateSequenceMessage = new TerminateSequenceMessage(rmNamespace, soapNamespace);
        OMElement identifierElement = terminateSequenceElement.getFirstElement();
        terminateSequenceMessage.setIdentifier(identifierElement.getText());
        Iterator iter = soapEnvelope.getHeader().getChildrenWithLocalName("SequenceAcknowledgement");
        if (iter.hasNext()) {
            SOAPHeaderBlock sequenceAcknowledgmentHeaderBlock = (SOAPHeaderBlock)iter.next();
            SequenceAcknowledgment sequenceAcknowledgment = SequenceAcknowledgment.fromSOAPHeaderBlock(sequenceAcknowledgmentHeaderBlock);
            terminateSequenceMessage.setSequenceAcknowledgment(sequenceAcknowledgment);
        }
        return terminateSequenceMessage;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SequenceAcknowledgment getSequenceAcknowledgment() {
        return this.sequenceAcknowledgment;
    }

    public void setSequenceAcknowledgment(SequenceAcknowledgment sequenceAcknowledgment) {
        this.sequenceAcknowledgment = sequenceAcknowledgment;
    }
}

