/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.AcknowledgmentRange;
import org.wso2.mercury.message.RMMessageHeader;

public class SequenceAcknowledgment
extends RMMessageHeader {
    private String identifier;
    private List acknowledgmentRanges;

    public SequenceAcknowledgment() {
        this.acknowledgmentRanges = new ArrayList();
    }

    public SequenceAcknowledgment(String identifier) {
        this.identifier = identifier;
        this.acknowledgmentRanges = new ArrayList();
    }

    public void addAcknowledgmentRange(AcknowledgmentRange range) {
        this.acknowledgmentRanges.add(range);
    }

    public void populateAcknowledgmentRanges(Set acknowlegments) {
        ArrayList numbers = new ArrayList(acknowlegments);
        if (numbers.size() > 0) {
            Collections.sort(numbers);
            long lowerlimit = this.getNumber(numbers, 0);
            long upperlimit = this.getNumber(numbers, 0);
            for (int i = 1; i < numbers.size(); ++i) {
                long currentNumber = this.getNumber(numbers, i);
                if (currentNumber > upperlimit + 1L) {
                    this.acknowledgmentRanges.add(new AcknowledgmentRange(upperlimit, lowerlimit));
                    lowerlimit = currentNumber;
                    upperlimit = currentNumber;
                    continue;
                }
                upperlimit = currentNumber;
            }
            this.acknowledgmentRanges.add(new AcknowledgmentRange(upperlimit, lowerlimit));
        }
    }

    private long getNumber(List numbers, int position) {
        return (Long)numbers.get(position);
    }

    public SOAPHeaderBlock toSOAPHeaderBlock() throws RMMessageBuildingException {
        SOAPFactory soapFactory = this.getSoapFactory();
        OMNamespace omNamespace = soapFactory.createOMNamespace("http://schemas.xmlsoap.org/ws/2005/02/rm", "wsrm");
        SOAPHeaderBlock sequenceAcknowledgment = soapFactory.createSOAPHeaderBlock("SequenceAcknowledgement", omNamespace);
        OMElement identifierElement = soapFactory.createOMElement("Identifier", this.rmNamespace, "wsrm");
        identifierElement.setText(this.identifier);
        sequenceAcknowledgment.addChild((OMNode)identifierElement);
        AcknowledgmentRange acknowledgmentRange2 = null;
        for (AcknowledgmentRange acknowledgmentRange2 : this.acknowledgmentRanges) {
            sequenceAcknowledgment.addChild((OMNode)acknowledgmentRange2.toOM());
        }
        return sequenceAcknowledgment;
    }

    public static SequenceAcknowledgment fromSOAPHeaderBlock(SOAPHeaderBlock soapHeaderBlock) throws RMMessageBuildingException {
        soapHeaderBlock.setProcessed();
        String soapNamespace = soapHeaderBlock.getQName().getNamespaceURI();
        SequenceAcknowledgment sequenceAcknowledgment = new SequenceAcknowledgment();
        sequenceAcknowledgment.setSoapNamesapce(soapNamespace);
        String rmNamesapce = soapHeaderBlock.getNamespace().getNamespaceURI();
        sequenceAcknowledgment.setRmNamespace(rmNamesapce);
        Iterator elementIter = soapHeaderBlock.getChildElements();
        while (elementIter.hasNext()) {
            OMElement childElement = (OMElement)elementIter.next();
            if (childElement.getLocalName().equals("Identifier")) {
                sequenceAcknowledgment.setIdentifier(childElement.getText());
                continue;
            }
            if (!childElement.getLocalName().equals("AcknowledgementRange")) continue;
            sequenceAcknowledgment.addAcknowledgmentRange(AcknowledgmentRange.fromOM(childElement));
        }
        return sequenceAcknowledgment;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List getAcknowledgmentRanges() {
        return this.acknowledgmentRanges;
    }

    public void setAcknowledgmentRanges(List acknowledgmentRanges) {
        this.acknowledgmentRanges = acknowledgmentRanges;
    }
}

