/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMMessageHeader;

public class Sequence
extends RMMessageHeader {
    private long messageNumber;
    private boolean isLastMessage;
    private String sequenceID;

    public SOAPHeaderBlock toSOAPHeaderBlock() throws RMMessageBuildingException {
        SOAPFactory soapFactory = this.getSoapFactory();
        OMNamespace rmNamespace = soapFactory.createOMNamespace("http://schemas.xmlsoap.org/ws/2005/02/rm", "wsrm");
        SOAPHeaderBlock sequenceHeaderBolck = soapFactory.createSOAPHeaderBlock("Sequence", rmNamespace);
        OMElement identifierElement = soapFactory.createOMElement("Identifier", this.rmNamespace, "wsrm");
        identifierElement.setText(this.sequenceID);
        sequenceHeaderBolck.addChild((OMNode)identifierElement);
        OMElement messageNumberElement = soapFactory.createOMElement("MessageNumber", this.rmNamespace, "wsrm");
        messageNumberElement.setText(String.valueOf(this.messageNumber));
        sequenceHeaderBolck.addChild((OMNode)messageNumberElement);
        if (this.isLastMessage) {
            OMElement lastMessageElement = soapFactory.createOMElement("LastMessage", this.rmNamespace, "wsrm");
            sequenceHeaderBolck.addChild((OMNode)lastMessageElement);
        }
        return sequenceHeaderBolck;
    }

    public static Sequence fromSOAPHeaderBlock(SOAPHeaderBlock soapHeaderBlock) {
        soapHeaderBlock.setProcessed();
        String soapNamespace = soapHeaderBlock.getQName().getNamespaceURI();
        Sequence sequence = new Sequence();
        sequence.setSoapNamesapce(soapNamespace);
        String rmNamesapce = soapHeaderBlock.getNamespace().getNamespaceURI();
        sequence.setRmNamespace(rmNamesapce);
        soapHeaderBlock.setProcessed();
        if (soapHeaderBlock.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/rm")) {
            Iterator sequenceElementIter = soapHeaderBlock.getChildElements();
            while (sequenceElementIter.hasNext()) {
                OMElement childElement = (OMElement)sequenceElementIter.next();
                if (childElement.getLocalName().equals("Identifier")) {
                    sequence.setSequenceID(childElement.getText());
                    continue;
                }
                if (childElement.getLocalName().equals("MessageNumber")) {
                    sequence.setMessageNumber(Long.parseLong(childElement.getText()));
                    continue;
                }
                if (!childElement.getLocalName().equals("LastMessage")) continue;
                sequence.setLastMessage(true);
            }
        }
        return sequence;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
    }

    public boolean isLastMessage() {
        return this.isLastMessage;
    }

    public void setLastMessage(boolean lastMessage) {
        this.isLastMessage = lastMessage;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(String sequenceID) {
        this.sequenceID = sequenceID;
    }
}

