/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.Iterator;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.message.SequenceAcknowledgment;

public class RMApplicationMessage
extends RMMessage {
    private SOAPEnvelope originalMessage;
    private boolean isSequenceHeaderAdded;
    private SequenceAcknowledgment sequenceAcknowledgment;
    private Sequence sequence;

    public RMApplicationMessage(SOAPEnvelope originalMessage) {
        this.soapNamesapce = originalMessage.getNamespace().getNamespaceURI();
        this.originalMessage = originalMessage;
        this.isSequenceHeaderAdded = false;
    }

    public RMApplicationMessage(String rmNamespace, String soapNamesapce, SOAPEnvelope originalMessage) {
        super(rmNamespace, soapNamesapce);
        this.originalMessage = originalMessage;
        this.isSequenceHeaderAdded = false;
    }

    public SOAPEnvelope toSOAPEnvelope() throws RMMessageBuildingException {
        if (!this.isSequenceHeaderAdded) {
            if (this.originalMessage.getHeader() == null) {
                SOAPFactory soapFactory = this.getSoapFactory();
                soapFactory.createSOAPHeader(this.originalMessage);
            }
            this.originalMessage.getHeader().addChild((OMNode)this.sequence.toSOAPHeaderBlock());
            this.isSequenceHeaderAdded = true;
        }
        if (this.sequenceAcknowledgment != null) {
            Iterator iter = this.originalMessage.getHeader().getChildrenWithLocalName("SequenceAcknowledgement");
            while (iter.hasNext()) {
                SOAPHeaderBlock sequenceAcknowledgmentHeaderBlock = (SOAPHeaderBlock)iter.next();
                if (!sequenceAcknowledgmentHeaderBlock.getLocalName().equals("SequenceAcknowledgement")) continue;
                sequenceAcknowledgmentHeaderBlock.detach();
                break;
            }
            this.originalMessage.getHeader().addChild((OMNode)this.sequenceAcknowledgment.toSOAPHeaderBlock());
        }
        Iterator iter = this.originalMessage.getHeader().getChildElements();
        while (iter.hasNext()) {
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)iter.next();
            if (!soapHeaderBlock.getLocalName().equals("RelatesTo")) continue;
            soapHeaderBlock.detach();
        }
        return this.originalMessage;
    }

    public static RMApplicationMessage fromSOAPEnvelope(SOAPEnvelope soapEnvelope) throws RMMessageBuildingException {
        String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
        Iterator childElements = soapEnvelope.getHeader().getChildElements();
        RMApplicationMessage rmApplicationMessage = null;
        while (childElements.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)childElements.next();
            if (!headerBlock.getLocalName().equals("Sequence")) continue;
            String rmNamespace = headerBlock.getNamespace().getNamespaceURI();
            rmApplicationMessage = new RMApplicationMessage(rmNamespace, soapNamespace, soapEnvelope);
            rmApplicationMessage.setSequence(Sequence.fromSOAPHeaderBlock(headerBlock));
        }
        Iterator iter = soapEnvelope.getHeader().getChildrenWithLocalName("SequenceAcknowledgement");
        while (iter.hasNext()) {
            SOAPHeaderBlock sequenceAcknowledgmentHeaderBlock = (SOAPHeaderBlock)iter.next();
            if (!sequenceAcknowledgmentHeaderBlock.getLocalName().equals("SequenceAcknowledgement")) continue;
            SequenceAcknowledgment sequenceAcknowledgment = SequenceAcknowledgment.fromSOAPHeaderBlock(sequenceAcknowledgmentHeaderBlock);
            rmApplicationMessage.setSequenceAcknowledgment(sequenceAcknowledgment);
            break;
        }
        return rmApplicationMessage;
    }

    public SOAPEnvelope getOriginalMessage() {
        return this.originalMessage;
    }

    public void setOriginalMessage(SOAPEnvelope originalMessage) {
        this.originalMessage = originalMessage;
    }

    public boolean isSequenceHeaderAdded() {
        return this.isSequenceHeaderAdded;
    }

    public void setSequenceHeaderAdded(boolean sequenceHeaderAdded) {
        this.isSequenceHeaderAdded = sequenceHeaderAdded;
    }

    public SequenceAcknowledgment getSequenceAcknowledgment() {
        return this.sequenceAcknowledgment;
    }

    public void setSequenceAcknowledgment(SequenceAcknowledgment sequenceAcknowledgment) {
        this.sequenceAcknowledgment = sequenceAcknowledgment;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }
}

