/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.Iterator;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.message.SequenceAcknowledgment;

public class LastMessage
extends RMMessage {
    private Sequence sequence;
    private SequenceAcknowledgment sequenceAcknowledgment;

    public LastMessage(Sequence sequence) {
        this.sequence = sequence;
    }

    public LastMessage(String rmNamespace, String soapNamesapce) {
        super(rmNamespace, soapNamesapce);
    }

    public SOAPEnvelope toSOAPEnvelope() throws RMMessageBuildingException {
        SOAPFactory soapFactory = this.getSoapFactory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        if (this.sequenceAcknowledgment != null) {
            soapEnvelope.getHeader().addChild((OMNode)this.sequenceAcknowledgment.toSOAPHeaderBlock());
        }
        soapEnvelope.getHeader().addChild((OMNode)this.sequence.toSOAPHeaderBlock());
        return soapEnvelope;
    }

    public static LastMessage fromSOAPEnvelope(SOAPEnvelope soapEnvelope) throws RMMessageBuildingException {
        String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
        Iterator childElements = soapEnvelope.getHeader().getChildElements();
        LastMessage lastMessage = null;
        while (childElements.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)childElements.next();
            if (!headerBlock.getLocalName().equals("Sequence")) continue;
            String rmNamespace = headerBlock.getNamespace().getNamespaceURI();
            lastMessage = new LastMessage(rmNamespace, soapNamespace);
            lastMessage.setSequence(Sequence.fromSOAPHeaderBlock(headerBlock));
        }
        Iterator iter = soapEnvelope.getHeader().getChildrenWithLocalName("SequenceAcknowledgement");
        while (iter.hasNext()) {
            SOAPHeaderBlock sequenceAcknowledgmentHeaderBlock = (SOAPHeaderBlock)iter.next();
            if (!sequenceAcknowledgmentHeaderBlock.getLocalName().equals("SequenceAcknowledgement")) continue;
            SequenceAcknowledgment sequenceAcknowledgment = SequenceAcknowledgment.fromSOAPHeaderBlock(sequenceAcknowledgmentHeaderBlock);
            lastMessage.setSequenceAcknowledgment(sequenceAcknowledgment);
            break;
        }
        return lastMessage;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public SequenceAcknowledgment getSequenceAcknowledgment() {
        return this.sequenceAcknowledgment;
    }

    public void setSequenceAcknowledgment(SequenceAcknowledgment sequenceAcknowledgment) {
        this.sequenceAcknowledgment = sequenceAcknowledgment;
    }
}

