/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.Accept;
import org.wso2.mercury.message.RMMessage;

public class CreateSequenceResponseMessage
extends RMMessage {
    private String identifier;
    private Accept accept;
    private static Log log = LogFactory.getLog(CreateSequenceResponseMessage.class);

    public CreateSequenceResponseMessage(String rmNamespace, String soapNamesapce) {
        super(rmNamespace, soapNamesapce);
    }

    public CreateSequenceResponseMessage() {
    }

    public SOAPEnvelope toSOAPEnvelope() throws RMMessageBuildingException {
        SOAPFactory soapFactory = this.getSoapFactory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        OMElement createSequenceResponseElement = soapFactory.createOMElement("CreateSequenceResponse", this.rmNamespace, "wsrm");
        OMElement identifierElement = soapFactory.createOMElement("Identifier", this.rmNamespace, "wsrm");
        identifierElement.setText(this.identifier);
        createSequenceResponseElement.addChild((OMNode)identifierElement);
        if (this.accept != null) {
            createSequenceResponseElement.addChild((OMNode)this.accept.toOM());
        }
        soapEnvelope.getBody().addChild((OMNode)createSequenceResponseElement);
        return soapEnvelope;
    }

    public static CreateSequenceResponseMessage fromSOAPEnvolope(SOAPEnvelope soapEnvelope) throws RMMessageBuildingException {
        String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
        OMElement createSequenceResponseOMElement = soapEnvelope.getBody().getFirstElement();
        String rmNamespace = createSequenceResponseOMElement.getNamespace().getNamespaceURI();
        CreateSequenceResponseMessage createSequenceResponseMessage = new CreateSequenceResponseMessage(rmNamespace, soapNamespace);
        Iterator responseChildren = createSequenceResponseOMElement.getChildElements();
        OMElement omElement = null;
        while (responseChildren.hasNext()) {
            omElement = (OMElement)responseChildren.next();
            if (omElement.getLocalName().equals("Identifier")) {
                createSequenceResponseMessage.setIdentifier(omElement.getText());
                continue;
            }
            if (!omElement.getLocalName().equals("Accept")) continue;
            createSequenceResponseMessage.setAccept(Accept.fromOM(omElement));
        }
        if (!createSequenceResponseMessage.isValid()) {
            log.error((Object)"Invalid Create sequence response received");
            throw new RMMessageBuildingException("Invalid Create sequence response received");
        }
        return createSequenceResponseMessage;
    }

    public boolean isValid() {
        boolean isValid = false;
        if (this.identifier != null) {
            isValid = true;
        }
        return isValid;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Accept getAccept() {
        return this.accept;
    }

    public void setAccept(Accept accept) {
        this.accept = accept;
    }
}

