/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.AcksTo;
import org.wso2.mercury.message.Offer;
import org.wso2.mercury.message.RMMessage;

public class CreateSequenceMessage
extends RMMessage {
    private String addressingNamespace;
    private String acksToAddress;
    private String offerIdentifier;

    public CreateSequenceMessage() {
    }

    public CreateSequenceMessage(String rmNamespace, String soapNamesapce) {
        super(rmNamespace, soapNamesapce);
    }

    public SOAPEnvelope toSOAPEnvelope() throws RMMessageBuildingException {
        SOAPFactory soapFactory = this.getSoapFactory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        OMElement createSequence = soapFactory.createOMElement("CreateSequence", "http://schemas.xmlsoap.org/ws/2005/02/rm", "wsrm");
        AcksTo acksTo = new AcksTo(this.rmNamespace);
        acksTo.setEndpointAddress(this.acksToAddress);
        createSequence.addChild((OMNode)acksTo.toOM());
        if (this.offerIdentifier != null) {
            Offer offer = new Offer(this.offerIdentifier);
            offer.setRmNamespace(this.rmNamespace);
            createSequence.addChild((OMNode)offer.toOM());
        }
        soapEnvelope.getBody().addChild((OMNode)createSequence);
        return soapEnvelope;
    }

    public static CreateSequenceMessage fromSOAPEnvelope(SOAPEnvelope soapEnvelope) throws RMMessageBuildingException {
        String soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
        OMElement createSequenceOMElement = soapEnvelope.getBody().getFirstElement();
        String rmNamespace = createSequenceOMElement.getNamespace().getNamespaceURI();
        CreateSequenceMessage createSequenceMessage = new CreateSequenceMessage(rmNamespace, soapNamespace);
        OMElement omElement = null;
        Iterator iter = createSequenceOMElement.getChildElements();
        while (iter.hasNext()) {
            omElement = (OMElement)iter.next();
            if (omElement.getLocalName().equals("AcksTo")) {
                AcksTo acksTo = AcksTo.fromOM(omElement);
                createSequenceMessage.setAddressingNamespace(acksTo.getAddressingNamespace());
                createSequenceMessage.setAcksToAddress(acksTo.getEndpointAddress());
                continue;
            }
            if (!omElement.getLocalName().equals("Offer")) continue;
            Offer offer = Offer.fromOM(omElement);
            createSequenceMessage.setOfferIdentifier(offer.getIdentifer());
        }
        return createSequenceMessage;
    }

    public String getAddressingNamespace() {
        return this.addressingNamespace;
    }

    public void setAddressingNamespace(String addressingNamespace) {
        this.addressingNamespace = addressingNamespace;
    }

    public String getAcksToAddress() {
        return this.acksToAddress;
    }

    public void setAcksToAddress(String acksToAddress) {
        this.acksToAddress = acksToAddress;
    }

    public String getOfferIdentifier() {
        return this.offerIdentifier;
    }

    public void setOfferIdentifier(String offerIdentifier) {
        this.offerIdentifier = offerIdentifier;
    }
}

