/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMMessageElement;

public class AcksTo
extends RMMessageElement {
    private String addressingNamespace;
    private String endpointAddress;

    public AcksTo(String rmNamespace) {
        this.rmNamespace = rmNamespace;
    }

    public String getRMNamespaceValue() {
        return this.rmNamespace;
    }

    public OMElement toOM() throws RMMessageBuildingException {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement acksTo = omFactory.createOMElement("AcksTo", this.rmNamespace, "wsrm");
        if (this.addressingNamespace == null) {
            this.addressingNamespace = "http://www.w3.org/2005/08/addressing";
        }
        OMElement address = omFactory.createOMElement("Address", this.addressingNamespace, "wsa");
        address.setText(this.endpointAddress);
        acksTo.addChild((OMNode)address);
        return acksTo;
    }

    public static AcksTo fromOM(OMElement omElement) throws RMMessageBuildingException {
        String rmNamesapce = omElement.getNamespace().getNamespaceURI();
        OMElement address = omElement.getFirstElement();
        if (!address.getLocalName().equals("Address")) {
            throw new RMMessageBuildingException("Can not Address element in AcksTo element");
        }
        AcksTo acksTo = new AcksTo(rmNamesapce);
        acksTo.setAddressingNamespace(address.getNamespace().getNamespaceURI());
        acksTo.setEndpointAddress(address.getText());
        return acksTo;
    }

    public String getAddressingNamespace() {
        return this.addressingNamespace;
    }

    public void setAddressingNamespace(String addressingNamespace) {
        this.addressingNamespace = addressingNamespace;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }
}

