/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.message;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMMessageElement;

public class AcknowledgmentRange
extends RMMessageElement {
    private long upper;
    private long lower;

    public AcknowledgmentRange() {
    }

    public AcknowledgmentRange(String rmNamespace) {
        super(rmNamespace);
    }

    public AcknowledgmentRange(long upper, long lower) {
        this.upper = upper;
        this.lower = lower;
    }

    public OMElement toOM() throws RMMessageBuildingException {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement omElement = omFactory.createOMElement("AcknowledgementRange", this.rmNamespace, "wsrm");
        omElement.addAttribute("Upper", String.valueOf(this.upper), null);
        omElement.addAttribute("Lower", String.valueOf(this.lower), null);
        return omElement;
    }

    public static AcknowledgmentRange fromOM(OMElement omElement) throws RMMessageBuildingException {
        String rmNamespace = omElement.getNamespace().getNamespaceURI();
        long upperLimit = Long.parseLong(omElement.getAttributeValue(new QName(null, "Upper")));
        long lowerLimit = Long.parseLong(omElement.getAttributeValue(new QName(null, "Lower")));
        AcknowledgmentRange acknowledgmentRange = new AcknowledgmentRange(rmNamespace);
        acknowledgmentRange.setUpper(upperLimit);
        acknowledgmentRange.setLower(lowerLimit);
        return acknowledgmentRange;
    }

    public boolean isNumberInRange(long number) {
        return number >= this.lower && number <= this.upper;
    }

    public long getUpper() {
        return this.upper;
    }

    public void setUpper(long upper) {
        this.upper = upper;
    }

    public long getLower() {
        return this.lower;
    }

    public void setLower(long lower) {
        this.lower = lower;
    }
}

