/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMApplicationMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.util.RMDispatchInfo;

public class MercurySequenceIDDispatcher
extends AbstractHandler {
    private static Log log = LogFactory.getLog(MercurySequenceIDDispatcher.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getOptions().getRelatesTo() != null) {
            String action = msgContext.getOptions().getAction();
            if (action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
                return Handler.InvocationResponse.CONTINUE;
            }
            try {
                Sequence sequence;
                RMApplicationMessage rmApplicationMessage = RMApplicationMessage.fromSOAPEnvelope(msgContext.getEnvelope());
                if (rmApplicationMessage != null && (sequence = rmApplicationMessage.getSequence()) != null) {
                    String sequenceID = sequence.getSequenceID();
                    RMDispatchInfo rmDispatchInfo = (RMDispatchInfo)msgContext.getConfigurationContext().getProperty("RMDispatchInfo");
                    AxisOperation axisOperation = rmDispatchInfo.getAxisOperation(sequenceID);
                    if (axisOperation != null) {
                        if (msgContext.getAxisOperation() == null) {
                            msgContext.setAxisOperation(axisOperation);
                        }
                        if (msgContext.getAxisService() == null) {
                            msgContext.setAxisService(axisOperation.getAxisService());
                        }
                    }
                }
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)"Invalid soap message");
                throw new AxisFault("Invalid soap message");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

