/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.callback.MercuryErrorCallback;
import org.wso2.mercury.keys.InternalSequenceKey;
import org.wso2.mercury.message.RMApplicationMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.persistence.PersistenceManager;
import org.wso2.mercury.persistence.dto.InternalKeyDto;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.state.Axis2Info;
import org.wso2.mercury.state.RMDContext;
import org.wso2.mercury.state.RMDSequence;
import org.wso2.mercury.state.RMSContext;
import org.wso2.mercury.state.RMSSequence;
import org.wso2.mercury.util.MercuryParameterHandler;
import org.wso2.mercury.util.RMUtil;
import org.wso2.mercury.workers.RMSSequenceWorker;

public class MercuryOutHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(MercuryOutHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        MessageContext responseMessageContext;
        MessageContext inBoundMessageContext;
        if (msgContext.getProperty("processRMControlMessage") != null && msgContext.getProperty("processRMControlMessage").equals("true")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!(!msgContext.isProcessingFault() && msgContext.getFLOW() != 4 || msgContext.getProperty("applicationFault") != null && msgContext.getProperty("applicationFault").equals("true"))) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgContext.getProperty("MercuryInternalKey") == null) {
            if (msgContext.isServerSide()) {
                MessageContext inBoundMessageContext2 = msgContext.getOperationContext().getMessageContext("In");
                if (inBoundMessageContext2.getProperty("SessionID") == null) return Handler.InvocationResponse.CONTINUE;
                msgContext.setProperty("MercuryInternalKey", inBoundMessageContext2.getProperty("SessionID"));
            } else {
                msgContext.setProperty("MercuryInternalKey", (Object)"DefaultInternalKey");
            }
        }
        InternalSequenceKey key = new InternalSequenceKey(msgContext.getTo().getAddress(), (String)msgContext.getProperty("MercuryInternalKey"));
        RMSContext rmsContext = (RMSContext)msgContext.getConfigurationContext().getProperty("MercuryRMSContext");
        if (msgContext.getProperty("MercuryResumeSequence") != null && msgContext.getProperty("MercuryResumeSequence").equals("true")) {
            try {
                log.info((Object)("Resuming Sequence with the Key -" + key.getInternalKey() + " address-" + key.getEndPointAddress()));
                rmsContext.resumeSequence(key, msgContext);
                return Handler.InvocationResponse.ABORT;
            }
            catch (PersistenceException e) {
                log.error((Object)"Can not load the saved state ", (Throwable)e);
                throw new AxisFault("Can not load the saved state ", (Throwable)e);
            }
        }
        RMSSequence rmsSequence = rmsContext.getRMSSeqenceWithInternalKey(key);
        if (msgContext.isServerSide() && msgContext.getProperty("MercuryLastMessage") == null && (inBoundMessageContext = msgContext.getOperationContext().getMessageContext("In")).getProperty("MercuryLastMessage") != null) {
            msgContext.setProperty("MercuryLastMessage", inBoundMessageContext.getProperty("MercuryLastMessage"));
        }
        if (rmsSequence == null) {
            String addressingNamespace;
            if (msgContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage")) {
                return Handler.InvocationResponse.ABORT;
            }
            boolean isLastMessage = false;
            log.info((Object)("Starting a new sequence to key -" + key.getInternalKey() + " address-" + key.getEndPointAddress()));
            if (msgContext.getProperty("MercuryLastMessage") != null && msgContext.getProperty("MercuryLastMessage").equals("true")) {
                isLastMessage = true;
                rmsSequence = new RMSSequence(1, msgContext.getTo());
            } else {
                rmsSequence = new RMSSequence(0, msgContext.getTo());
            }
            if (msgContext.getProperty("MercuryErrorCallback") != null) {
                MercuryErrorCallback errorCallback = (MercuryErrorCallback)msgContext.getProperty("MercuryErrorCallback");
                rmsSequence.setErrorCallback(errorCallback);
            }
            RMApplicationMessage rmApplicationMessage = new RMApplicationMessage(msgContext.getEnvelope());
            Sequence sequence = new Sequence();
            sequence.setLastMessage(isLastMessage);
            rmApplicationMessage.setSequence(sequence);
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportInDescription transportIn = msgContext.getTransportIn();
            if (transportIn == null) {
                transportIn = msgContext.getOptions().getTransportIn();
            }
            if (transportIn == null && msgContext.getOptions().isUseSeparateListener()) {
                transportIn = ClientUtils.inferInTransport((AxisConfiguration)msgContext.getConfigurationContext().getAxisConfiguration(), (Options)msgContext.getOptions(), (MessageContext)msgContext);
            }
            if ((addressingNamespace = (String)msgContext.getProperty("WSAddressingVersion")) == null) {
                addressingNamespace = "http://www.w3.org/2005/08/addressing";
            }
            Axis2Info axis2Info = new Axis2Info();
            axis2Info.setServiceContext(msgContext.getServiceContext());
            axis2Info.setOptions(msgContext.getOptions());
            axis2Info.setTransportIn(transportIn);
            axis2Info.setTransportOut(transportOut);
            axis2Info.setServerSide(msgContext.isServerSide());
            axis2Info.setSoapNamespaceURI(msgContext.getEnvelope().getNamespace().getNamespaceURI());
            axis2Info.setProperties(msgContext.getProperties());
            axis2Info.setAddressingNamespaceURI(addressingNamespace);
            rmsSequence.setAxis2Info(axis2Info);
            MercuryParameterHandler mercuryParameterHandler = new MercuryParameterHandler((AxisDescription)msgContext.getAxisService());
            rmsSequence.setRetransmitTime(mercuryParameterHandler.getRMSSequenceRetransmitTime());
            rmsSequence.setTimeoutTime(mercuryParameterHandler.getRMSSequenceTimeout());
            rmsSequence.setMaximumRetrasmitCount(mercuryParameterHandler.getRMSMaximumRetransmitCount());
            if (msgContext.getOptions().isUseSeparateListener() || msgContext.isServerSide()) {
                rmsSequence.setAckToEpr(msgContext.getConfigurationContext().getListenerManager().getEPRforService(msgContext.getAxisService().getName(), msgContext.getAxisOperation().getName().getLocalPart(), transportIn.getName()));
                rmsSequence.setAnnonymous(false);
            } else {
                rmsSequence.setAnnonymous(true);
                if (addressingNamespace.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) {
                    rmsSequence.setAckToEpr(new EndpointReference("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"));
                } else {
                    rmsSequence.setAckToEpr(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
                }
            }
            if (msgContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-in") && (msgContext.getProperty("MercurySequenceOffer") != null && msgContext.getProperty("MercurySequenceOffer").equals("true") || rmsSequence.isAnnonymous())) {
                String offerID = RMUtil.getUUID();
                rmsSequence.setSequenceOffer(offerID);
                RMDContext rmdContext = (RMDContext)msgContext.getProperty("MercuryRMDContext");
                RMDSequence offeredRMDSequence = rmdContext.createRMDSequenceWithOffer(offerID, msgContext.getTo().getAddress(), axis2Info, rmsSequence.isAnnonymous());
                if (rmsSequence.isAnnonymous()) {
                    offeredRMDSequence.setOfferedRMSSequence(rmsSequence);
                    rmsSequence.setOfferedRMDSequence(offeredRMDSequence);
                }
            }
            if (msgContext.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
                PersistenceManager persistenceManager = (PersistenceManager)msgContext.getConfigurationContext().getProperty("rmPersistanceManager");
                InternalKeyDto internalKeyDto = new InternalKeyDto(key.getInternalKey(), key.getEndPointAddress());
                try {
                    persistenceManager.save(internalKeyDto);
                    rmsSequence.save(internalKeyDto.getId());
                }
                catch (PersistenceException e) {
                    log.error((Object)"Can not persists objects", (Throwable)e);
                    throw new AxisFault("Can not persists objects", (Throwable)e);
                }
            }
            try {
                rmsSequence.addRMMessageContext(rmApplicationMessage, msgContext);
            }
            catch (PersistenceException e) {
                log.error((Object)"Can not persists objects", (Throwable)e);
                throw new AxisFault("Can not save the message", (Throwable)e);
            }
            rmsContext.registerRMSSequenceToInternalKey(key, rmsSequence);
            RMSSequenceWorker rmsSequenceWorker = new RMSSequenceWorker(rmsSequence);
            rmsSequenceWorker.setSequenceWorkerSleepTime(mercuryParameterHandler.getRMSSequenceWorkerSleepTime());
            msgContext.getConfigurationContext().getThreadPool().execute((Runnable)rmsSequenceWorker);
        } else {
            RMApplicationMessage rmApplicationMessage = new RMApplicationMessage(msgContext.getEnvelope());
            Sequence sequence = new Sequence();
            rmApplicationMessage.setSequence(sequence);
            boolean isLastMessage = false;
            boolean isTerminateMessage = false;
            if (msgContext.getProperty("MercuryLastMessage") != null && msgContext.getProperty("MercuryLastMessage").equals("true")) {
                log.debug((Object)"Last message received");
                isLastMessage = true;
            }
            if (msgContext.getProperty("MercuryTerminateMessage") != null && msgContext.getProperty("MercuryTerminateMessage").equals("true")) {
                log.debug((Object)"Terminate message received");
                isTerminateMessage = true;
            }
            sequence.setLastMessage(isLastMessage);
            try {
                if (isLastMessage) {
                    rmsSequence.lastMessageReceivedFromClient(rmApplicationMessage, msgContext);
                } else if (isTerminateMessage) {
                    sequence.setLastMessage(true);
                    msgContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
                    rmsSequence.lastMessageReceivedFromClient(rmApplicationMessage, msgContext);
                } else {
                    rmsSequence.applicationMessageReceivedFromClient(rmApplicationMessage, msgContext);
                }
            }
            catch (PersistenceException e) {
                log.error((Object)"Can not save the message", (Throwable)e);
                throw new AxisFault("Can not save the message", (Throwable)e);
            }
        }
        if (!rmsSequence.isAnnonymous() || !msgContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/out-in")) return Handler.InvocationResponse.SUSPEND;
        MessageContext messageContext = responseMessageContext = msgContext.getOperationContext().getMessageContext("In");
        synchronized (messageContext) {
            try {
                log.debug((Object)"Waiting until response message receives");
                responseMessageContext.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return Handler.InvocationResponse.SUSPEND;
        }
    }
}

