/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.handlers;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.context.MercuryMessageContext;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.AcknowledgmentRange;
import org.wso2.mercury.message.CreateSequenceResponseMessage;
import org.wso2.mercury.message.RMApplicationMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.message.SequenceAcknowledgment;
import org.wso2.mercury.message.SequenceAcknowledgmentMessage;
import org.wso2.mercury.message.TerminateSequenceMessage;
import org.wso2.mercury.persistence.exception.PersistenceException;
import org.wso2.mercury.state.RMDContext;
import org.wso2.mercury.state.RMDSequence;
import org.wso2.mercury.state.RMSContext;
import org.wso2.mercury.state.RMSSequence;
import org.wso2.mercury.util.AxisFaultUtil;
import org.wso2.mercury.util.MercuryParameterHandler;

public class MercuryInHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(MercuryInHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        log.debug((Object)("Receiving the message with action ==> " + msgContext.getOptions().getAction()));
        if (msgContext.getProperty("processRMControlMessage") != null && msgContext.getProperty("processRMControlMessage").equals("true")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence")) {
            RMDContext rmdContext = (RMDContext)msgContext.getConfigurationContext().getProperty("MercuryRMDContext");
            try {
                RMDSequence rmdSequence = rmdContext.processCreateSequenceRequest(msgContext);
                if (rmdSequence.isAnonymous()) {
                    rmdSequence.sendCreateSequenceResponseMessage();
                }
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (msgContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse")) {
            RMSContext rmsContext = (RMSContext)msgContext.getConfigurationContext().getProperty("MercuryRMSContext");
            CreateSequenceResponseMessage createSequenceResponseMessage = null;
            try {
                createSequenceResponseMessage = CreateSequenceResponseMessage.fromSOAPEnvolope(msgContext.getEnvelope());
                RMSSequence rmsSequence = rmsContext.getRMSSequence(msgContext.getRelatesTo().getValue(), createSequenceResponseMessage.getIdentifier());
                if (rmsSequence != null) {
                    rmsSequence.createSequenceResponseReceived();
                }
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                RMSSequence rmsSequence = rmsContext.getRMSSequenceWithMessageID(msgContext.getOptions().getRelatesTo().getValue());
                if (rmsSequence != null) {
                    rmsSequence.invalidCreateSequenceResponseReceived();
                }
                return Handler.InvocationResponse.ABORT;
            }
            catch (PersistenceException e) {
                rmsContext.unRegisterRMSSequenceWithSequenceID(createSequenceResponseMessage.getIdentifier());
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (msgContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement")) {
            SequenceAcknowledgmentMessage sequenceAcknowledgmentMessage = null;
            SequenceAcknowledgment sequenceAcknowledgment = null;
            try {
                sequenceAcknowledgmentMessage = SequenceAcknowledgmentMessage.fromSOAPEnvelope(msgContext.getEnvelope());
                sequenceAcknowledgment = sequenceAcknowledgmentMessage.getSequenceAcknowledgment();
                RMSContext rmsContext = (RMSContext)msgContext.getConfigurationContext().getProperty("MercuryRMSContext");
                RMSSequence rmsSequence = rmsContext.getRMSSequenceWithSequenceID(sequenceAcknowledgment.getIdentifier());
                if (rmsSequence != null) {
                    rmsSequence.sequenceAcknowledgmentReceived(sequenceAcknowledgment.getAcknowledgmentRanges());
                }
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (PersistenceException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (msgContext.getOptions().getAction().equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
            TerminateSequenceMessage terminateSequenceMessage = null;
            try {
                terminateSequenceMessage = TerminateSequenceMessage.fromSOAPEnvelpe(msgContext.getEnvelope());
                RMDContext rmdContext = (RMDContext)msgContext.getConfigurationContext().getProperty("MercuryRMDContext");
                RMDSequence rmdSequence = rmdContext.getRMDSeqenceWithSequenceID(terminateSequenceMessage.getIdentifier());
                if (rmdSequence != null) {
                    rmdSequence.terminateSequenceMessageReceived();
                }
                if (rmdSequence.getOfferedRMSSequence() != null) {
                    RMSSequence offeredRMSequence = rmdSequence.getOfferedRMSSequence();
                    if (terminateSequenceMessage.getSequenceAcknowledgment() != null) {
                        offeredRMSequence.sequenceAcknowledgmentReceived(terminateSequenceMessage.getSequenceAcknowledgment().getAcknowledgmentRanges());
                    }
                    if (msgContext.isServerSide()) {
                        offeredRMSequence.sendTerminateSequenceMessage(msgContext);
                    }
                }
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
            catch (PersistenceException e) {
                log.error((Object)"Can not save the state");
            }
            return Handler.InvocationResponse.ABORT;
        }
        RMApplicationMessage rmApplicationMessage = null;
        try {
            rmApplicationMessage = RMApplicationMessage.fromSOAPEnvelope(msgContext.getEnvelope());
        }
        catch (RMMessageBuildingException e) {
            log.error((Object)"Can not build the sequence acknowledgmet message ", (Throwable)e);
            throw new AxisFault("Can not build the sequence acknowledgmet message ", (Throwable)e);
        }
        if (rmApplicationMessage != null) {
            block69: {
                Sequence sequence = rmApplicationMessage.getSequence();
                if (sequence.getSequenceID() == null) {
                    return Handler.InvocationResponse.CONTINUE;
                }
                log.debug((Object)("Application message " + sequence.getMessageNumber() + " received for " + sequence.getSequenceID()));
                MercuryMessageContext mercuryMessageContext = new MercuryMessageContext(rmApplicationMessage, msgContext);
                msgContext.setProperty("SessionID", (Object)sequence.getSequenceID());
                RMDContext rmdContext = (RMDContext)msgContext.getConfigurationContext().getProperty("MercuryRMDContext");
                RMDSequence rmdSequence = rmdContext.getRMDSeqenceWithSequenceID(sequence.getSequenceID());
                if (rmdSequence == null && msgContext.getConfigurationContext().getProperty("rmPersistanceManager") != null) {
                    try {
                        rmdContext.loadRMDSequenceFromPersistanceStorage(sequence.getSequenceID(), msgContext);
                        rmdSequence = rmdContext.getRMDSeqenceWithSequenceID(sequence.getSequenceID());
                    }
                    catch (PersistenceException e) {
                        log.error((Object)"Can not save the message", (Throwable)e);
                    }
                }
                if (rmdSequence == null) {
                    log.error((Object)("Unknow message with seuqnce ID ==> " + sequence.getSequenceID()));
                    throw new AxisFault("Unknow message with seuqnce ID ==> " + sequence.getSequenceID());
                }
                try {
                    Object object;
                    boolean newMessageReceived = false;
                    if (sequence.isLastMessage()) {
                        msgContext.setProperty("MercuryLastMessage", (Object)"true");
                        object = rmdSequence.getInvokerBuffer();
                        synchronized (object) {
                            newMessageReceived = rmdSequence.lastMessageReceived(sequence.getMessageNumber(), mercuryMessageContext);
                        }
                    }
                    object = rmdSequence.getInvokerBuffer();
                    synchronized (object) {
                        newMessageReceived = rmdSequence.applicationMessageReceived(sequence.getMessageNumber(), mercuryMessageContext);
                    }
                    if (rmdSequence.isAnonymous()) {
                        try {
                            RMSSequence offeredRMSSequence;
                            if (msgContext.getAxisOperation().getMessageExchangePattern().equals("http://www.w3.org/ns/wsdl/in-only") && rmdSequence.getOfferedRMSSequence() == null) {
                                object = mercuryMessageContext;
                                synchronized (object) {
                                    try {
                                        mercuryMessageContext.wait();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                                rmdSequence.sendSequenceAcknowledgementMessage(msgContext);
                                break block69;
                            }
                            if (msgContext.getProperty("NonBlockingTransport") != null && msgContext.getOptions().getRelatesTo() != null) {
                                offeredRMSSequence = rmdSequence.getOfferedRMSSequence();
                                AcknowledgmentRange acknowledgmentRange = new AcknowledgmentRange(sequence.getMessageNumber(), sequence.getMessageNumber());
                                ArrayList<AcknowledgmentRange> acknowledgmentRanges = new ArrayList<AcknowledgmentRange>();
                                acknowledgmentRanges.add(acknowledgmentRange);
                                offeredRMSSequence.sequenceAcknowledgmentReceived(acknowledgmentRanges);
                            } else if (msgContext.isServerSide()) {
                                offeredRMSSequence = rmdSequence.getOfferedRMSSequence();
                                SequenceAcknowledgment sequenceAcknowledgment = rmApplicationMessage.getSequenceAcknowledgment();
                                if (sequenceAcknowledgment != null) {
                                    offeredRMSSequence.sequenceAcknowledgmentReceived(sequenceAcknowledgment.getAcknowledgmentRanges());
                                }
                                offeredRMSSequence.sendApplicationMessageResponse(msgContext, sequence.getMessageNumber());
                            } else {
                                offeredRMSSequence = rmdSequence.getOfferedRMSSequence();
                                AcknowledgmentRange acknowledgmentRange = new AcknowledgmentRange(sequence.getMessageNumber(), sequence.getMessageNumber());
                                ArrayList<AcknowledgmentRange> acknowledgmentRanges = new ArrayList<AcknowledgmentRange>();
                                acknowledgmentRanges.add(acknowledgmentRange);
                                offeredRMSSequence.sequenceAcknowledgmentReceived(acknowledgmentRanges);
                                rmdSequence.getInvokerBuffer().waitUntilMessageInvoke(sequence.getMessageNumber());
                            }
                            break block69;
                        }
                        catch (RMMessageBuildingException e) {
                            log.error((Object)"Can not build the sequence acknowledgmet message ", (Throwable)e);
                            throw new AxisFault("Can not build the sequence acknowledgmet message ", (Throwable)e);
                        }
                    }
                    if (!newMessageReceived) break block69;
                    MercuryMessageContext e = mercuryMessageContext;
                    synchronized (e) {
                        try {
                            mercuryMessageContext.wait();
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                    }
                }
                catch (PersistenceException e) {
                    log.error((Object)"Can not save the message ", (Throwable)e);
                }
            }
            return Handler.InvocationResponse.ABORT;
        }
        MercuryParameterHandler mercuryParameterHandler = new MercuryParameterHandler((AxisDescription)msgContext.getAxisService());
        boolean enforceRM = mercuryParameterHandler.getEnforceRM();
        if (msgContext.getOptions().getRelatesTo() != null) {
            RMSContext rmsContext = (RMSContext)msgContext.getConfigurationContext().getProperty("MercuryRMSContext");
            RMSSequence rmsSequence = rmsContext.getRMSSequenceWithMessageID(msgContext.getOptions().getRelatesTo().getValue());
            if (rmsSequence != null) {
                rmsSequence.invalidCreateSequenceResponseReceived();
                return Handler.InvocationResponse.ABORT;
            }
        } else if (enforceRM) {
            String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
            QName faultCode = null;
            if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
                faultCode = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender", "soapenv");
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
                faultCode = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client", "soapenv");
            } else {
                log.debug((Object)("Unknown Soap Envelope namespace : " + nsURI));
            }
            AxisFault tmp = new AxisFault("This endpoint requires an RM message");
            if (faultCode != null) {
                ArrayList<QName> list = new ArrayList<QName>();
                String addressingNamespace = this.getAddressingNamesapce(msgContext);
                list.add(new QName(addressingNamespace, "ActionNotSupported", "wsa"));
                tmp.setFaultCode(faultCode);
                tmp.setFaultSubCodes(list);
            }
            MessageContext faultContext = AxisFaultUtil.generateAxisFaultMessageContext(msgContext, tmp);
            AxisFault fault = new AxisFault("This endpoint requires an RM message", faultContext);
            throw fault;
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private String getAddressingNamesapce(MessageContext messageContext) {
        String namespace = (String)messageContext.getProperty("WSAddressingVersion");
        if (namespace == null) {
            namespace = Utils.getParameterValue((Parameter)messageContext.getParameter("WSAddressingVersion"));
        }
        if (namespace == null) {
            namespace = "http://www.w3.org/2005/08/addressing";
        }
        return namespace;
    }
}

