/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mercury.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mercury.exception.RMMessageBuildingException;
import org.wso2.mercury.message.RMApplicationMessage;
import org.wso2.mercury.message.Sequence;
import org.wso2.mercury.state.RMDContext;
import org.wso2.mercury.state.RMDSequence;

public class MercuryDuplicationHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(MercuryDuplicationHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getOptions().getRelatesTo() != null) {
            String action = msgContext.getOptions().getAction();
            if (action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
                return Handler.InvocationResponse.CONTINUE;
            }
            try {
                RMDContext rmdContext;
                RMDSequence rmdSequence;
                Sequence sequence;
                RMApplicationMessage rmApplicationMessage = RMApplicationMessage.fromSOAPEnvelope(msgContext.getEnvelope());
                if (rmApplicationMessage != null && (sequence = rmApplicationMessage.getSequence()) != null && (rmdSequence = (rmdContext = (RMDContext)msgContext.getConfigurationContext().getProperty("MercuryRMDContext")).getRMDSeqenceWithSequenceID(sequence.getSequenceID())).isMessageReceived(sequence.getMessageNumber())) {
                    return Handler.InvocationResponse.ABORT;
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            catch (RMMessageBuildingException e) {
                log.error((Object)"Invalid soap message");
                throw new AxisFault("Invalid soap message");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

