/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.UnparsedTextURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardUnparsedTextResolver
implements UnparsedTextURIResolver {
    public Reader resolve(URI uRI, String string, Configuration configuration) throws XPathException {
        URL uRL;
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            DynamicError dynamicError = new DynamicError("Cannot convert absolute URI to URL", malformedURLException);
            dynamicError.setErrorCode("XTDE1170");
            throw dynamicError;
        }
        try {
            Object object;
            Object object2;
            InputStream inputStream;
            if (string != null) {
                inputStream = uRL.openStream();
            } else {
                object2 = uRL.openConnection();
                ((URLConnection)object2).connect();
                inputStream = ((URLConnection)object2).getInputStream();
                try {
                    int n;
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                    if (!"file".equals(((URLConnection)object2).getURL().getProtocol()) && (object = ((URLConnection)object2).getContentType()) != null && (n = ((String)object).indexOf("charset")) >= 0) {
                        if ((n = ((String)object).indexOf(61, n + 7)) >= 0) {
                            object = ((String)object).substring(n + 1);
                        }
                        if ((n = ((String)object).indexOf(59)) > 0) {
                            object = ((String)object).substring(0, n);
                        }
                        if ((n = ((String)object).indexOf(40)) > 0) {
                            object = ((String)object).substring(0, n);
                        }
                        if ((n = ((String)object).indexOf(34)) > 0) {
                            object = ((String)object).substring(n + 1, ((String)object).indexOf(34, n + 2));
                        }
                        string = ((String)object).trim();
                    }
                    if (string == null) {
                        inputStream.mark(100);
                        byte[] byArray = new byte[100];
                        int n2 = inputStream.read(byArray, 0, 100);
                        inputStream.reset();
                        string = this.inferEncoding(byArray, n2);
                    }
                }
                catch (IOException iOException) {
                    string = "UTF-8";
                }
            }
            object2 = Charset.forName(string);
            object = ((Charset)object2).newDecoder();
            object = ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
            object = ((CharsetDecoder)object).onUnmappableCharacter(CodingErrorAction.REPORT);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, (CharsetDecoder)object));
            return bufferedReader;
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    private String inferEncoding(byte[] byArray, int n) {
        if (n >= 2) {
            if (this.ch(byArray[0]) == 254 && this.ch(byArray[1]) == 255) {
                return "UTF-16";
            }
            if (this.ch(byArray[0]) == 255 && this.ch(byArray[1]) == 254) {
                return "UTF-16LE";
            }
        }
        if (n >= 3 && this.ch(byArray[0]) == 239 && this.ch(byArray[1]) == 187 && this.ch(byArray[2]) == 191) {
            return "UTF-8";
        }
        if (n >= 4) {
            if (this.ch(byArray[0]) == 60 && this.ch(byArray[1]) == 63 && this.ch(byArray[2]) == 120 && this.ch(byArray[3]) == 109 && this.ch(byArray[4]) == 108) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    fastStringBuffer.append((char)byArray[i]);
                }
                String string = fastStringBuffer.toString();
                int n2 = string.indexOf("encoding");
                if (n2 >= 0) {
                    n2 += 8;
                    while (n2 < string.length() && " \n\r\t=\"'".indexOf(string.charAt(n2)) >= 0) {
                        ++n2;
                    }
                    fastStringBuffer.setLength(0);
                    while (n2 < string.length() && string.charAt(n2) != '\"' && string.charAt(n2) != '\'') {
                        fastStringBuffer.append(string.charAt(n2++));
                    }
                    return fastStringBuffer.toString();
                }
            }
        } else {
            if (n > 0 && byArray[0] == 0 && byArray[2] == 0 && byArray[4] == 0 && byArray[6] == 0) {
                return "UTF-16";
            }
            if (n > 1 && byArray[1] == 0 && byArray[3] == 0 && byArray[5] == 0 && byArray[7] == 0) {
                return "UTF-16LE";
            }
        }
        return "UTF-8";
    }

    private int ch(byte by) {
        return by & 0xFF;
    }
}

