/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.IntSet;

public class IntRangeSet
implements Serializable,
IntSet {
    private int[] startPoints;
    private int[] endPoints;
    private int used = 0;
    private int hashCode = -1;
    private int size = 0;

    public IntRangeSet() {
        this.startPoints = new int[4];
        this.endPoints = new int[4];
        this.used = 0;
        this.size = 0;
        this.hashCode = -1;
    }

    public IntRangeSet(IntRangeSet intRangeSet) {
        this.startPoints = new int[intRangeSet.used];
        this.endPoints = new int[intRangeSet.used];
        this.used = intRangeSet.used;
        System.arraycopy(intRangeSet.startPoints, 0, this.startPoints, 0, this.used);
        System.arraycopy(intRangeSet.endPoints, 0, this.endPoints, 0, this.used);
        this.hashCode = intRangeSet.hashCode;
    }

    public void clear() {
        this.startPoints = new int[4];
        this.endPoints = new int[4];
        this.used = 0;
        this.hashCode = -1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int n) {
        if (n > this.endPoints[this.used - 1]) {
            return false;
        }
        if (n < this.startPoints[0]) {
            return false;
        }
        int n2 = 0;
        int n3 = this.used;
        do {
            int n4;
            if (this.endPoints[n4 = n2 + (n3 - n2) / 2] < n) {
                n2 = Math.max(n4, n2 + 1);
                continue;
            }
            if (this.startPoints[n4] > n) {
                n3 = Math.min(n4, n3 - 1);
                continue;
            }
            return true;
        } while (n2 != n3);
        return false;
    }

    public boolean remove(int n) {
        throw new UnsupportedOperationException("remove");
    }

    public boolean add(int n) {
        this.hashCode = -1;
        if (this.used == 0) {
            this.ensureCapacity(1);
            this.startPoints[this.used - 1] = n;
            this.endPoints[this.used - 1] = n;
            ++this.size;
            return true;
        }
        if (n > this.endPoints[this.used - 1]) {
            if (n == this.endPoints[this.used - 1] + 1) {
                int n2 = this.used - 1;
                this.endPoints[n2] = this.endPoints[n2] + 1;
            } else {
                this.ensureCapacity(this.used + 1);
                this.startPoints[this.used - 1] = n;
                this.endPoints[this.used - 1] = n;
            }
            ++this.size;
            return true;
        }
        if (n < this.startPoints[0]) {
            if (n == this.startPoints[0] - 1) {
                this.startPoints[0] = this.startPoints[0] - 1;
            } else {
                this.ensureCapacity(this.used + 1);
                System.arraycopy(this.startPoints, 0, this.startPoints, 1, this.used - 1);
                System.arraycopy(this.endPoints, 0, this.endPoints, 1, this.used - 1);
                this.startPoints[0] = n;
                this.endPoints[0] = n;
            }
            ++this.size;
            return true;
        }
        int n3 = 0;
        int n4 = this.used;
        do {
            int n5;
            if (this.endPoints[n5 = n3 + (n4 - n3) / 2] < n) {
                n3 = Math.max(n5, n3 + 1);
                continue;
            }
            if (this.startPoints[n5] > n) {
                n4 = Math.min(n5, n4 - 1);
                continue;
            }
            return false;
        } while (n3 != n4);
        if (n3 > 0 && this.endPoints[n3 - 1] + 1 == n) {
            --n3;
        } else if (n3 < this.used - 1 && this.startPoints[n3 + 1] - 1 == n) {
            ++n3;
        }
        if (this.endPoints[n3] + 1 == n) {
            if (n == this.startPoints[n3 + 1] - 1) {
                this.endPoints[n3] = this.endPoints[n3 + 1];
                System.arraycopy(this.startPoints, n3 + 2, this.startPoints, n3 + 1, this.used - n3 - 2);
                System.arraycopy(this.endPoints, n3 + 2, this.endPoints, n3 + 1, this.used - n3 - 2);
                --this.used;
            } else {
                int n6 = n3;
                this.endPoints[n6] = this.endPoints[n6] + 1;
            }
            ++this.size;
            return true;
        }
        if (this.startPoints[n3] - 1 == n) {
            if (n == this.endPoints[n3 - 1] + 1) {
                this.endPoints[n3 - 1] = this.endPoints[n3];
                System.arraycopy(this.startPoints, n3 + 1, this.startPoints, n3, this.used - n3 - 1);
                System.arraycopy(this.endPoints, n3 + 1, this.endPoints, n3, this.used - n3 - 1);
                --this.used;
            } else {
                int n7 = n3;
                this.startPoints[n7] = this.startPoints[n7] - 1;
            }
            ++this.size;
            return true;
        }
        if (n > this.endPoints[n3]) {
            ++n3;
        }
        this.ensureCapacity(this.used + 1);
        try {
            System.arraycopy(this.startPoints, n3, this.startPoints, n3 + 1, this.used - n3 - 1);
            System.arraycopy(this.endPoints, n3, this.endPoints, n3 + 1, this.used - n3 - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.startPoints[n3] = n;
        this.endPoints[n3] = n;
        ++this.size;
        return true;
    }

    private void ensureCapacity(int n) {
        if (this.startPoints.length < n) {
            int[] nArray = new int[this.startPoints.length * 2];
            int[] nArray2 = new int[this.startPoints.length * 2];
            System.arraycopy(this.startPoints, 0, nArray, 0, this.used);
            System.arraycopy(this.endPoints, 0, nArray2, 0, this.used);
            this.startPoints = nArray;
            this.endPoints = nArray2;
        }
        this.used = n;
    }

    public IntIterator iterator() {
        return new IntRangeSetIterator();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.used * 8);
        for (int i = 0; i < this.used; ++i) {
            fastStringBuffer.append(this.startPoints[i] + "-" + this.endPoints[i] + ",");
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IntRangeSet) {
            return this.used == ((IntRangeSet)object).used && Arrays.equals(this.startPoints, ((IntRangeSet)object).startPoints) && Arrays.equals(this.endPoints, ((IntRangeSet)object).endPoints);
        }
        return this.containsAll((IntSet)object);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n = -2090169871;
            for (int i = 0; i < this.used; ++i) {
                n ^= this.startPoints[i] + (this.endPoints[i] << 3);
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean containsAll(IntSet intSet) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        IntRangeSet intRangeSet = new IntRangeSet();
        intRangeSet.add(10);
        intRangeSet.add(14);
        intRangeSet.add(5);
        intRangeSet.add(12);
        intRangeSet.add(6);
        intRangeSet.add(4);
        intRangeSet.add(13);
        System.err.println(intRangeSet);
    }

    private class IntRangeSetIterator
    implements IntIterator,
    Serializable {
        private int i = -1;
        private int current = Integer.MIN_VALUE;

        public boolean hasNext() {
            if (this.i < 0) {
                return IntRangeSet.this.size > 0;
            }
            return this.current < IntRangeSet.this.endPoints[IntRangeSet.this.used - 1];
        }

        public int next() {
            if (this.i < 0) {
                this.i = 0;
                this.current = IntRangeSet.this.startPoints[0];
                return this.current;
            }
            if (this.current == IntRangeSet.this.endPoints[this.i]) {
                this.current = IntRangeSet.this.startPoints[++this.i];
                return this.current;
            }
            return ++this.current;
        }
    }
}

