/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.utils.http;

import java.util.LinkedList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class ScriptEnginePool {
    private static final int DEFAULT_SIZE = 10;
    private LinkedList pool = new LinkedList();
    private int engines = 0;
    private int capacity = 0;
    private ScriptEngineFactory factory;
    private boolean isMultithreaded = false;

    public ScriptEnginePool(ScriptEngineFactory factory, int capacity) {
        this.factory = factory;
        this.capacity = capacity;
        String param = (String)factory.getParameter("THREADING");
        if (param != null && param.equals("MULTITHREADED")) {
            this.isMultithreaded = true;
            this.pool.add(factory.getScriptEngine());
        }
    }

    public ScriptEnginePool(ScriptEngineFactory factory) {
        this(factory, 10);
    }

    public synchronized void free(ScriptEngine eng) {
        this.pool.add(eng);
        this.notifyAll();
    }

    public synchronized ScriptEngine get() {
        if (this.isMultithreadingSupported()) {
            return (ScriptEngine)this.pool.getFirst();
        }
        if (!this.pool.isEmpty()) {
            return (ScriptEngine)this.pool.removeFirst();
        }
        if (this.engines < this.capacity) {
            ++this.engines;
            return this.factory.getScriptEngine();
        }
        while (!this.pool.isEmpty()) {
            this.waiting();
        }
        return (ScriptEngine)this.pool.removeFirst();
    }

    public boolean isMultithreadingSupported() {
        return this.isMultithreaded;
    }

    public void waiting() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

