/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.IORunnable;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;

abstract class ArchiveFileSystemController
extends ArchiveController {
    private AutoMounter autoMounter = new ResetFileSystem();
    static final /* synthetic */ boolean $assertionsDisabled;

    ArchiveFileSystemController(File target, ArchiveController enclController, String enclEntryName, ArchiveDriver driver) {
        super(target, enclController, enclEntryName, driver);
    }

    final boolean isTouched() {
        ArchiveFileSystem fileSystem = this.getFileSystem();
        return fileSystem != null && fileSystem.isTouched();
    }

    void touch() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        this.setScheduled(true);
    }

    final ArchiveFileSystem autoMount(boolean autoCreate) throws IOException {
        if (!($assertionsDisabled || this.readLock().isLocked() || this.writeLock().isLocked())) {
            throw new AssertionError();
        }
        return this.autoMounter.autoMount(autoCreate);
    }

    final ArchiveFileSystem getFileSystem() {
        return this.autoMounter.getFileSystem();
    }

    final void setFileSystem(ArchiveFileSystem fileSystem) {
        this.autoMounter.setFileSystem(fileSystem);
    }

    abstract void mount(boolean var1) throws IOException;

    void reset() throws IOException {
        this.setFileSystem(null);
    }

    final ArchiveEntry createArchiveEntry(String entryName, ArchiveEntry blueprint) throws CharConversionException {
        return this.getDriver().createArchiveEntry(this, entryName, blueprint);
    }

    static {
        $assertionsDisabled = !ArchiveFileSystemController.class.desiredAssertionStatus();
    }

    private class FalsePositiveFileSystem
    extends AutoMounter {
        private final ArchiveController.FalsePositiveException exception;
        static final /* synthetic */ boolean $assertionsDisabled;

        private FalsePositiveFileSystem(ArchiveController.FalsePositiveException exception) {
            if (!$assertionsDisabled && exception == null) {
                throw new AssertionError((Object)"It's illegal to use this state with null as the IOException!");
            }
            this.exception = exception;
        }

        ArchiveFileSystem autoMount(boolean create) throws IOException {
            throw this.exception;
        }

        void setFileSystem(ArchiveFileSystem fileSystem) {
            if (!$assertionsDisabled && fileSystem != null) {
                throw new AssertionError((Object)"It's illegal to assign a file system to an archive controller for a false positive archive file!");
            }
            ArchiveFileSystemController.this.autoMounter = new ResetFileSystem();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystemController == null ? (class$de$schlichtherle$io$ArchiveFileSystemController = ArchiveFileSystemController.class$("de.schlichtherle.io.ArchiveFileSystemController")) : class$de$schlichtherle$io$ArchiveFileSystemController).desiredAssertionStatus();
        }
    }

    private class MountedFileSystem
    extends AutoMounter {
        private final ArchiveFileSystem fileSystem;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MountedFileSystem(ArchiveFileSystem fileSystem) {
            if (!$assertionsDisabled && fileSystem == null) {
                throw new AssertionError((Object)"It's illegal to use this state with null as the file system!");
            }
            this.fileSystem = fileSystem;
        }

        ArchiveFileSystem autoMount(boolean create) throws IOException {
            return this.fileSystem;
        }

        ArchiveFileSystem getFileSystem() {
            return this.fileSystem;
        }

        void setFileSystem(ArchiveFileSystem fileSystem) {
            if (!$assertionsDisabled && fileSystem != null) {
                throw new AssertionError((Object)"It's illegal to assign a file system to an archive controller which already has its file system mounted!");
            }
            ArchiveFileSystemController.this.autoMounter = new ResetFileSystem();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystemController == null ? (class$de$schlichtherle$io$ArchiveFileSystemController = ArchiveFileSystemController.class$("de.schlichtherle.io.ArchiveFileSystemController")) : class$de$schlichtherle$io$ArchiveFileSystemController).desiredAssertionStatus();
        }
    }

    private class ResetFileSystem
    extends AutoMounter {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ResetFileSystem() {
        }

        ArchiveFileSystem autoMount(boolean create) throws IOException {
            try {
                class Mounter
                implements IORunnable {
                    static final /* synthetic */ boolean $assertionsDisabled;
                    private final /* synthetic */ boolean val$create;

                    Mounter(boolean bl) {
                        this.val$create = bl;
                    }

                    public void run() throws IOException {
                        if (ArchiveFileSystemController.this.autoMounter == ResetFileSystem.this) {
                            ArchiveFileSystemController.this.mount(this.val$create);
                            if (!$assertionsDisabled && !(ArchiveFileSystemController.this.autoMounter instanceof MountedFileSystem)) {
                                throw new AssertionError();
                            }
                        } else {
                            if (!$assertionsDisabled && ArchiveFileSystemController.this.autoMounter == null) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && ArchiveFileSystemController.this.autoMounter instanceof ResetFileSystem) {
                                throw new AssertionError();
                            }
                        }
                    }

                    static {
                        $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystemController == null ? (class$de$schlichtherle$io$ArchiveFileSystemController = ArchiveFileSystemController.class$("de.schlichtherle.io.ArchiveFileSystemController")) : class$de$schlichtherle$io$ArchiveFileSystemController).desiredAssertionStatus();
                    }
                }
                ArchiveFileSystemController.this.runWriteLocked(new Mounter(create));
            }
            catch (ArchiveController.FalsePositiveException ex) {
                if (ex.isCacheable()) {
                    ArchiveFileSystemController.this.autoMounter = new FalsePositiveFileSystem(ex);
                }
                throw ex;
            }
            if (!$assertionsDisabled && ArchiveFileSystemController.this.autoMounter == this) {
                throw new AssertionError();
            }
            return ArchiveFileSystemController.this.autoMounter.autoMount(create);
        }

        void setFileSystem(ArchiveFileSystem fileSystem) {
            if (fileSystem != null) {
                ArchiveFileSystemController.this.autoMounter = new MountedFileSystem(fileSystem);
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystemController == null ? (class$de$schlichtherle$io$ArchiveFileSystemController = ArchiveFileSystemController.class$("de.schlichtherle.io.ArchiveFileSystemController")) : class$de$schlichtherle$io$ArchiveFileSystemController).desiredAssertionStatus();
        }
    }

    private static abstract class AutoMounter {
        private AutoMounter() {
        }

        abstract ArchiveFileSystem autoMount(boolean var1) throws IOException;

        ArchiveFileSystem getFileSystem() {
            return null;
        }

        abstract void setFileSystem(ArchiveFileSystem var1);
    }
}

