/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.policy.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.policy.SandeshaPolicyBean;

public class RMAssertionBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        this.processElements(policy.getPolicyComponents(), propertyBean);
        return propertyBean;
    }

    public QName[] getKnownElements() {
        return new QName[]{new QName("http://ws.apache.org/sandesha2/policy", "RMAssertion")};
    }

    private void processElements(List policyComponents, SandeshaPolicyBean propertyBean) {
        Iterator iterator = policyComponents.iterator();
        while (iterator.hasNext()) {
            String value;
            XmlPrimtiveAssertion xmlPrimtiveAssertion = (XmlPrimtiveAssertion)iterator.next();
            OMElement element = xmlPrimtiveAssertion.getValue();
            String name = element.getLocalName();
            if ("AcknowledgementInterval".equals(name)) {
                propertyBean.setAcknowledgementInterval(Long.parseLong(element.getText().trim()));
                continue;
            }
            if ("ExponentialBackoff".equals(name)) {
                propertyBean.setExponentialBackoff(Boolean.valueOf(element.getText().trim()));
                continue;
            }
            if ("InactivityTimeout".equals(name)) {
                propertyBean.setInactiveTimeoutValue(Long.parseLong(element.getText().trim()));
                continue;
            }
            if ("InactivityTimeoutMeasure".equals(name)) {
                propertyBean.setInactivityTimeoutMeasure(element.getText().trim());
                continue;
            }
            if ("SequenceRemovalTimeout".equals(name)) {
                propertyBean.setSequenceRemovalTimeoutValue(Long.parseLong(element.getText().trim()));
                continue;
            }
            if ("SequenceRemovalTimeoutMeasure".equals(name)) {
                propertyBean.setSequenceRemovalTimeoutMeasure(element.getText().trim());
                continue;
            }
            if ("InvokeInOrder".equals(name)) {
                value = element.getText().trim();
                boolean inOrder = false;
                if (value != null && "true".equals(value)) {
                    inOrder = true;
                }
                propertyBean.setInOrder(inOrder);
                continue;
            }
            if ("MaximumRetransmissionCount".equals(name)) {
                propertyBean.setMaximumRetransmissionCount(Integer.parseInt(element.getText().trim()));
                continue;
            }
            if ("MessageTypesToDrop".equals(name)) {
                ArrayList<Integer> types = new ArrayList<Integer>();
                String str = element.getText().trim();
                String[] items = str.split(",");
                if (items != null) {
                    int size = items.length;
                    for (int i = 0; i < size; ++i) {
                        String itemStr = items[i];
                        if (itemStr.equals("") || itemStr.equals("none")) continue;
                        types.add(new Integer(itemStr));
                    }
                }
                propertyBean.setMsgTypesToDrop(types);
                continue;
            }
            if ("RetransmissionInterval".equals(name)) {
                propertyBean.setRetransmissionInterval(Long.parseLong(element.getText().trim()));
                continue;
            }
            if ("SecurityManager".equals(name)) {
                propertyBean.setSecurityManagerClass(element.getText().trim());
                continue;
            }
            if ("StorageManagers".equals(name)) {
                OMElement permanentStorageManagerElem;
                if (element == null) continue;
                OMElement inmemoryStorageManagerElem = element.getFirstChildWithName(Sandesha2Constants.Assertions.Q_ELEM_INMEMORY_STORAGE_MGR);
                if (inmemoryStorageManagerElem != null) {
                    String inMemoryStorageMgr = inmemoryStorageManagerElem.getText().trim();
                    propertyBean.setInMemoryStorageManagerClass(inMemoryStorageMgr);
                }
                if ((permanentStorageManagerElem = element.getFirstChildWithName(Sandesha2Constants.Assertions.Q_ELEM_PERMANENT_STORAGE_MGR)) == null) continue;
                String permanentStorageMgr = permanentStorageManagerElem.getText().trim();
                propertyBean.setPermanentStorageManagerClass(permanentStorageMgr);
                continue;
            }
            if ("ContextManager".equals(name)) {
                propertyBean.setContextManagerClass(element.getText().trim());
                continue;
            }
            if ("MakeConnection".equals(name)) {
                OMElement useRMAnonElem;
                if (element == null) continue;
                OMElement enabledElem = element.getFirstChildWithName(Sandesha2Constants.Assertions.Q_ELEM_ENABLED);
                if (enabledElem != null) {
                    String data = enabledElem.getText().trim();
                    propertyBean.setEnableMakeConnection(Boolean.valueOf(data));
                }
                if ((useRMAnonElem = element.getFirstChildWithName(Sandesha2Constants.Assertions.Q_ELEM_USE_RM_ANON_URI)) == null) continue;
                String data = useRMAnonElem.getText().trim();
                propertyBean.setEnableRMAnonURI(Boolean.valueOf(data));
                continue;
            }
            if ("UseMessageSerialization".equals(name)) {
                value = element.getText().trim();
                propertyBean.setUseMessageSerialization(Boolean.valueOf(value));
                continue;
            }
            if (!"EnforceRM".equals(name)) continue;
            value = element.getText().trim();
            propertyBean.setEnforceRM(Boolean.valueOf(value));
        }
    }
}

