/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

public class RESTUtil {
    public static String getURI(MessageContext messageContext, String address) throws AxisFault {
        StringBuffer buff;
        address = address.substring(address.indexOf("//") + 2);
        address = address.substring(address.indexOf("/"));
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = WSDL20DefaultValueHolder.getDefaultValue((String)"whttp:queryParameterSeparator");
        }
        OMElement firstElement = messageContext.getEnvelope().getBody().getFirstElement();
        String params = "";
        if (firstElement != null) {
            address = address + "/" + firstElement.getLocalName();
            Iterator iter = firstElement.getChildElements();
            String legalCharacters = "-._~!$'()*+,;=:@/?".replaceAll(queryParameterSeparator, "");
            buff = new StringBuffer(params);
            while (iter.hasNext()) {
                OMElement element = (OMElement)iter.next();
                try {
                    buff.append(URIEncoderDecoder.quoteIllegal((String)element.getLocalName(), (String)legalCharacters)).append("=").append(URIEncoderDecoder.quoteIllegal((String)element.getText(), (String)legalCharacters)).append(queryParameterSeparator);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AxisFault("URI Encoding error : " + element.getLocalName() + "=" + element.getText(), (Throwable)e);
                }
            }
        } else {
            throw new AxisFault("Cannot convert SOAP infoset to a GET URL-encoded format");
        }
        params = buff.toString();
        if (params.trim().length() != 0) {
            int index = address.indexOf("?");
            address = index == -1 ? address + "?" + params.substring(0, params.length() - 1) : (index == address.length() - 1 ? address + params.substring(0, params.length() - 1) : address + queryParameterSeparator + params.substring(0, params.length() - 1));
        }
        return address;
    }
}

