/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.transport.base.AbstractTransportListener;

public abstract class AbstractPollingTransportListener
extends AbstractTransportListener {
    public static final String TRANSPORT_POLL_INTERVAL = "transport.PollInterval";
    public static final int DEFAULT_POLL_INTERVAL = 300;
    protected int pollInterval = 300;
    protected final Timer timer = new Timer("PollTimer", true);
    protected boolean pollInProgress = false;
    protected final Object pollLock = new Object();
    protected Map serviceToTimerTaskMap = new HashMap();

    public void schedulePoll(AxisService service, long pollInterval) {
        pollInterval *= 1000L;
        TimerTask task = (TimerTask)this.serviceToTimerTaskMap.get(service);
        if (task != null) {
            task.cancel();
        }
        task = new TimerTask(){

            public void run() {
                if (AbstractPollingTransportListener.this.pollInProgress) {
                    if (AbstractPollingTransportListener.this.log.isDebugEnabled()) {
                        AbstractPollingTransportListener.this.log.debug((Object)("Transport " + AbstractPollingTransportListener.this.transportName + " onPoll() trigger : already executing poll.."));
                    }
                    return;
                }
                AbstractPollingTransportListener.this.workerPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = AbstractPollingTransportListener.this.pollLock;
                        synchronized (object) {
                            AbstractPollingTransportListener.this.pollInProgress = true;
                            try {
                                AbstractPollingTransportListener.this.onPoll();
                            }
                            finally {
                                AbstractPollingTransportListener.this.pollInProgress = false;
                            }
                        }
                    }
                });
            }
        };
        this.serviceToTimerTaskMap.put(service, task);
        this.timer.scheduleAtFixedRate(task, pollInterval, pollInterval);
    }

    public void cancelPoll(AxisService service) {
        TimerTask task = (TimerTask)this.serviceToTimerTaskMap.get(service);
        if (task != null) {
            task.cancel();
        }
    }

    public void onPoll() {
    }

    protected void startListeningForService(AxisService service) {
        Parameter param = service.getParameter(TRANSPORT_POLL_INTERVAL);
        long pollInterval = 300L;
        if (param != null && param.getValue() instanceof String) {
            try {
                pollInterval = Integer.parseInt(param.getValue().toString());
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Invalid poll interval : " + param.getValue() + " for service : " + service.getName() + " Using defaults"), (Throwable)e);
            }
        }
        this.schedulePoll(service, pollInterval);
    }

    protected void stopListeningForService(AxisService service) {
        this.cancelPoll(service);
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }
}

