/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.statistics.StatisticsCollector;
import org.apache.synapse.statistics.StatisticsStack;

public class ProxyServiceStatisticsStack
implements StatisticsStack {
    private static final Log log = LogFactory.getLog(ProxyServiceStatisticsStack.class);
    private String proxyServiceName;
    private boolean isStatisticsEnable = false;
    private long inTimeForInFlow = -1L;
    private long inTimeForOutFlow = -1L;
    private boolean isINFault;
    private boolean isOUTFault;

    public void put(String key, long initTime, boolean isInFlow, boolean isStatisticsEnable, boolean isFault) {
        if (isInFlow) {
            this.proxyServiceName = key;
            this.isStatisticsEnable = isStatisticsEnable;
            this.inTimeForInFlow = initTime;
            this.isINFault = isFault;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault) {
        ProxyServiceStatisticsStack proxyServiceStatisticsStack = this;
        synchronized (proxyServiceStatisticsStack) {
            if (this.proxyServiceName != null && this.isStatisticsEnable && this.inTimeForInFlow != -1L) {
                this.inTimeForOutFlow = System.currentTimeMillis();
                this.isOUTFault = isFault;
                statisticsCollector.reportForProxyService(this.proxyServiceName, false, this.inTimeForInFlow, this.inTimeForOutFlow, this.isINFault);
                this.inTimeForInFlow = -1L;
            } else if (this.inTimeForOutFlow != -1L) {
                statisticsCollector.reportForProxyService(this.proxyServiceName, true, this.inTimeForOutFlow, System.currentTimeMillis(), isFault);
                this.inTimeForOutFlow = -1L;
            }
        }
    }

    public void reportToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault, String name) {
        if (name != null && this.proxyServiceName != null && this.proxyServiceName.equals(name)) {
            this.reportToStatisticsCollector(statisticsCollector, isFault);
        } else {
            this.handleException("Invalid ProxyService Name " + name + " expected " + this.proxyServiceName);
        }
    }

    public void reportAllToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault) {
        this.reportToStatisticsCollector(statisticsCollector, isFault);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

