/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.aggregator;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregate
extends TimerTask {
    private static final Log log = LogFactory.getLog(Aggregate.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private long timeoutMillis = 0L;
    private long expiryTimeMillis = 0L;
    private int minCount = -1;
    private int maxCount = -1;
    private String correlation = null;
    private AggregateMediator aggregateMediator = null;
    private List<MessageContext> messages = new ArrayList<MessageContext>();

    public Aggregate(String corelation, long timeoutMillis, int min, int max, AggregateMediator mediator) {
        this.correlation = corelation;
        if (timeoutMillis > 0L) {
            this.expiryTimeMillis = System.currentTimeMillis() + timeoutMillis;
        }
        if (min > 0) {
            this.minCount = min;
        }
        if (max > 0) {
            this.maxCount = max;
        }
        this.aggregateMediator = mediator;
    }

    public boolean addMessage(MessageContext synCtx) {
        if (this.maxCount <= 0 || this.maxCount > 0 && this.messages.size() < this.maxCount) {
            this.messages.add(synCtx);
            return true;
        }
        return false;
    }

    public boolean isComplete(boolean traceOn, boolean traceOrDebugOn, Log trace, Log log) {
        if (!this.messages.isEmpty()) {
            MessageContext mc = this.messages.get(0);
            Object prop = mc.getProperty("messageSequence");
            if (prop != null && prop instanceof String) {
                String[] msgSequence = prop.toString().split("/");
                int total = Integer.parseInt(msgSequence[1]);
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, trace, log, this.messages.size() + " messages of " + total + " collected in current aggregation");
                }
                if (this.messages.size() >= total) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, trace, log, "Aggregation complete");
                    }
                    return true;
                }
            }
        } else if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, trace, log, "No messages collected in current aggregation");
        }
        if (this.minCount > 0 && this.messages.size() >= this.minCount) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, trace, log, "Aggregation complete - the minimum : " + this.minCount + " messages has been reached");
            }
            return true;
        }
        if (this.maxCount > 0 && this.messages.size() >= this.maxCount) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, trace, log, "Aggregation complete - the maximum : " + this.maxCount + " messages has been reached");
            }
            return true;
        }
        if (System.currentTimeMillis() >= this.expiryTimeMillis) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, trace, log, "Aggregation complete - the aggregation has timed out");
            }
            return true;
        }
        return false;
    }

    private void traceOrDebug(boolean traceOn, Log trace, Log log, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public String getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(String correlation) {
        this.correlation = correlation;
    }

    public List<MessageContext> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageContext> messages) {
        this.messages = messages;
    }

    public long getExpiryTimeMillis() {
        return this.expiryTimeMillis;
    }

    public void setExpiryTimeMillis(long expiryTimeMillis) {
        this.expiryTimeMillis = expiryTimeMillis;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Time : " + System.currentTimeMillis() + " and this aggregator expired at : " + this.expiryTimeMillis));
        }
        this.aggregateMediator.completeAggregate(this);
    }
}

