/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public class DBLookupMediator
extends AbstractDBMediator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStatement(Statement stmnt, MessageContext msgCtx) {
        block20: {
            boolean traceOn = this.isTraceOn(msgCtx);
            boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
            Connection con = null;
            try {
                PreparedStatement ps = this.getPreparedStatement(stmnt, msgCtx);
                con = ps.getConnection();
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Processing the first row returned : " + stmnt.getRawStatement());
                    }
                    for (String propName : stmnt.getResultsMap().keySet()) {
                        String columnStr = (String)stmnt.getResultsMap().get(propName);
                        Object obj = null;
                        try {
                            int colNum = Integer.parseInt(columnStr);
                            obj = rs.getObject(colNum);
                        }
                        catch (NumberFormatException ignore) {
                            obj = rs.getObject(columnStr);
                        }
                        if (obj != null) {
                            if (traceOrDebugOn) {
                                this.traceOrDebug(traceOn, "Column : " + columnStr + " returned value : " + obj + " Setting this as the message property : " + propName);
                            }
                            msgCtx.setProperty(propName, obj.toString());
                            continue;
                        }
                        if (!traceOrDebugOn) continue;
                        this.traceOrDebugWarn(traceOn, "Column : " + columnStr + " returned null Skip setting message property : " + propName);
                    }
                    break block20;
                }
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Statement : " + stmnt.getRawStatement() + " returned 0 rows");
                }
            }
            catch (SQLException e) {
                this.handleException("Error executing statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
    }
}

