/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.Stack;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.apache.synapse.statistics.impl.EndPointStatisticsStack;

public class WSDLEndpoint
extends FaultHandler
implements Endpoint {
    private static final Log log = LogFactory.getLog(AddressEndpoint.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private String name = null;
    private String wsdlURI;
    private OMElement wsdlDoc;
    private String serviceName;
    private String portName;
    private long suspendOnFailDuration = -1L;
    private long recoverOn = Long.MAX_VALUE;
    private boolean active = true;
    private Endpoint parentEndpoint = null;
    private EndpointDefinition endpoint = null;

    public void send(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Address Endpoint");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        String eprAddress = null;
        if (this.endpoint.getAddress() != null) {
            boolean statisticsEnable;
            eprAddress = this.endpoint.getAddress();
            String endPointName = this.getName();
            if (endPointName == null) {
                endPointName = "AnonymousEndpoint";
            }
            boolean bl = statisticsEnable = 1 == this.endpoint.getStatisticsState();
            if (statisticsEnable) {
                EndPointStatisticsStack endPointStatisticsStack = null;
                Object statisticsStackObj = synCtx.getProperty("synapse.endpoint.stats");
                if (statisticsStackObj == null) {
                    endPointStatisticsStack = new EndPointStatisticsStack();
                    synCtx.setProperty("synapse.endpoint.stats", endPointStatisticsStack);
                } else if (statisticsStackObj instanceof EndPointStatisticsStack) {
                    endPointStatisticsStack = (EndPointStatisticsStack)statisticsStackObj;
                }
                if (endPointStatisticsStack != null) {
                    boolean isFault = synCtx.getEnvelope().getBody().hasFault();
                    endPointStatisticsStack.put(endPointName, System.currentTimeMillis(), !synCtx.isResponse(), statisticsEnable, isFault);
                }
            }
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Sending message to WSDL endpoint : " + endPointName + " resolves to address = " + eprAddress);
                this.traceOrDebug(traceOn, "SOAPAction: " + (synCtx.getSoapAction() != null ? synCtx.getSoapAction() : "null"));
                this.traceOrDebug(traceOn, "WSA-Action: " + (synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null"));
                if (traceOn && trace.isTraceEnabled()) {
                    trace.trace((Object)("Envelope : \n" + synCtx.getEnvelope()));
                }
            }
            synCtx.pushFaultHandler(this);
            synCtx.setProperty("processed_endpoint", this);
            synCtx.getEnvironment().send(this.endpoint, synCtx);
        }
    }

    public void onFault(MessageContext synCtx) {
        this.setActive(false, synCtx);
        if (this.parentEndpoint != null) {
            this.parentEndpoint.onChildEndpointFail(this, synCtx);
        } else {
            Stack faultStack = synCtx.getFaultStack();
            if (!faultStack.isEmpty()) {
                ((FaultHandler)faultStack.pop()).handleFault(synCtx);
            }
        }
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public long getSuspendOnFailDuration() {
        return this.suspendOnFailDuration;
    }

    public void setSuspendOnFailDuration(long suspendOnFailDuration) {
        this.suspendOnFailDuration = suspendOnFailDuration;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public OMElement getWsdlDoc() {
        return this.wsdlDoc;
    }

    public void setWsdlDoc(OMElement wsdlDoc) {
        this.wsdlDoc = wsdlDoc;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public boolean isActive(MessageContext synMessageContext) {
        if (!this.active && System.currentTimeMillis() > this.recoverOn) {
            this.active = true;
        }
        return this.active;
    }

    public void setActive(boolean active, MessageContext synMessageContext) {
        if (!active) {
            this.recoverOn = this.suspendOnFailDuration != -1L ? System.currentTimeMillis() + this.suspendOnFailDuration : Long.MAX_VALUE;
        }
        this.active = active;
    }

    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    public EndpointDefinition getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(EndpointDefinition endpoint) {
        this.endpoint = endpoint;
    }

    protected boolean isTraceOn(MessageContext msgCtx) {
        return this.endpoint.getTraceState() == 1 || this.endpoint.getTraceState() == 2 && msgCtx.getTracingState() == 1;
    }

    protected boolean isTraceOrDebugOn(boolean isTraceOn) {
        return isTraceOn || log.isDebugEnabled();
    }

    protected void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }
}

