/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.List;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;

public class FailoverEndpoint
implements Endpoint {
    private String name = null;
    private volatile boolean active = true;
    private List endpoints = null;
    private Endpoint currentEndpoint = null;
    private Endpoint parentEndpoint = null;

    public void send(MessageContext synMessageContext) {
        synMessageContext.getEnvelope().build();
        if (this.currentEndpoint.isActive(synMessageContext)) {
            this.currentEndpoint.send(synMessageContext);
        } else {
            Endpoint liveEndpoint = null;
            boolean foundEndpoint = false;
            for (int i = 0; i < this.endpoints.size(); ++i) {
                liveEndpoint = (Endpoint)this.endpoints.get(i);
                if (!liveEndpoint.isActive(synMessageContext)) continue;
                foundEndpoint = true;
                this.currentEndpoint = liveEndpoint;
                this.currentEndpoint.send(synMessageContext);
                break;
            }
            if (!foundEndpoint) {
                this.setActive(false, synMessageContext);
                if (this.parentEndpoint != null) {
                    this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
                } else {
                    Object o = synMessageContext.getFaultStack().pop();
                    if (o != null) {
                        ((FaultHandler)o).handleFault(synMessageContext);
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public boolean isActive(MessageContext synMessageContext) {
        if (!this.active) {
            for (int i = 0; i < this.endpoints.size(); ++i) {
                Endpoint endpoint = (Endpoint)this.endpoints.get(i);
                if (!endpoint.isActive(synMessageContext)) continue;
                this.active = true;
            }
        }
        return this.active;
    }

    public void setActive(boolean active, MessageContext synMessageContext) {
        this.active = active;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
        if (endpoints.size() > 0) {
            this.currentEndpoint = (Endpoint)endpoints.get(0);
        }
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        this.send(synMessageContext);
    }

    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }
}

