/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.AnonymousServiceFactory;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.apache.synapse.util.MessageHelper;

public class Axis2FlexibleMEPClient {
    private static final Log log = LogFactory.getLog(Axis2FlexibleMEPClient.class);

    public static void send(EndpointDefinition endpoint, MessageContext synapseOutMessageContext) throws AxisFault {
        boolean separateListener = false;
        boolean wsSecurityEnabled = false;
        String wsSecPolicyKey = null;
        boolean wsRMEnabled = false;
        String wsRMPolicyKey = null;
        boolean wsAddressingEnabled = false;
        if (endpoint != null) {
            separateListener = endpoint.isUseSeparateListener();
            wsSecurityEnabled = endpoint.isSecurityOn();
            wsSecPolicyKey = endpoint.getWsSecPolicyKey();
            wsRMEnabled = endpoint.isReliableMessagingOn();
            wsRMPolicyKey = endpoint.getWsRMPolicyKey();
            boolean bl = wsAddressingEnabled = endpoint.isAddressingOn() || wsSecurityEnabled || wsRMEnabled;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending [add = " + wsAddressingEnabled + "] [sec = " + wsSecurityEnabled + "] [rm = " + wsRMEnabled + (endpoint != null ? "] [ mtom = " + endpoint.isUseMTOM() + "] [ swa = " + endpoint.isUseSwa() + "] [ format = " + endpoint.getFormat() + "] [ force soap11=" + endpoint.isForceSOAP11() + "] [ force soap12=" + endpoint.isForceSOAP12() + "] [ pox=" + endpoint.isForcePOX() + "] [ get=" + endpoint.isForcePOX() : "") + "] [ to " + synapseOutMessageContext.getTo() + "]"));
        }
        org.apache.axis2.context.MessageContext originalInMsgCtx = ((Axis2MessageContext)synapseOutMessageContext).getAxis2MessageContext();
        org.apache.axis2.context.MessageContext axisOutMsgCtx = Axis2FlexibleMEPClient.cloneForSend(originalInMsgCtx);
        if (endpoint != null) {
            if ("pox".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(true);
            } else if ("get".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"GET");
            } else if ("soap11".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(false);
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (!axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
                }
            } else if ("soap12".equals(endpoint.getFormat())) {
                axisOutMsgCtx.setDoingREST(false);
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
                }
            }
            if (endpoint.isUseMTOM()) {
                axisOutMsgCtx.setDoingMTOM(true);
                axisOutMsgCtx.setProperty("enableMTOM", (Object)"true");
                axisOutMsgCtx.setDoingMTOM(true);
            } else if (endpoint.isUseSwa()) {
                axisOutMsgCtx.setDoingSwA(true);
                axisOutMsgCtx.setProperty("enableSwA", (Object)"true");
                axisOutMsgCtx.setDoingSwA(true);
            }
            if (endpoint.getAddress() != null) {
                axisOutMsgCtx.setTo(new EndpointReference(endpoint.getAddress()));
            }
            if (endpoint.isUseSeparateListener()) {
                axisOutMsgCtx.getOptions().setUseSeparateListener(true);
            }
        }
        if (wsAddressingEnabled) {
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
        } else {
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        }
        ConfigurationContext axisCfgCtx = axisOutMsgCtx.getConfigurationContext();
        AxisConfiguration axisCfg = axisCfgCtx.getAxisConfiguration();
        AxisService anoymousService = AnonymousServiceFactory.getAnonymousService(synapseOutMessageContext.getConfiguration(), axisCfg, wsAddressingEnabled, wsRMEnabled, wsSecurityEnabled);
        ServiceGroupContext sgc = new ServiceGroupContext(axisCfgCtx, (AxisServiceGroup)anoymousService.getParent());
        ServiceContext serviceCtx = sgc.getServiceContext(anoymousService);
        boolean outOnlyMessage = "true".equals(synapseOutMessageContext.getProperty("OUT_ONLY"));
        AxisOperation axisAnonymousOperation = anoymousService.getOperation(outOnlyMessage ? new QName("__OUT_ONLY_OPERATION__") : new QName("__OUT_IN_OPERATION__"));
        Options clientOptions = new Options();
        clientOptions.setUseSeparateListener(separateListener);
        if (wsRMEnabled) {
            if (wsRMPolicyKey != null) {
                clientOptions.setProperty("sandeshaPolicy", (Object)Axis2FlexibleMEPClient.getPolicy(synapseOutMessageContext, wsRMPolicyKey));
            }
            Axis2FlexibleMEPClient.copyRMOptions(originalInMsgCtx, clientOptions);
        }
        if (wsSecurityEnabled) {
            if (wsSecPolicyKey != null) {
                clientOptions.setProperty("rampartPolicy", (Object)Axis2FlexibleMEPClient.getPolicy(synapseOutMessageContext, wsSecPolicyKey));
            }
            if (axisOutMsgCtx.getEnvelope().getHeader() == null) {
                SOAPFactory fac = axisOutMsgCtx.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                fac.createSOAPHeader(axisOutMsgCtx.getEnvelope());
            }
        }
        OperationClient mepClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        mepClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        if (!outOnlyMessage) {
            AsyncCallback callback = new AsyncCallback(synapseOutMessageContext);
            if (endpoint != null) {
                callback.setTimeOutOn(System.currentTimeMillis() + endpoint.getTimeoutDuration());
                callback.setTimeOutAction(endpoint.getTimeoutAction());
            } else {
                callback.setTimeOutOn(System.currentTimeMillis());
            }
            mepClient.setCallback((AxisCallback)callback);
        }
        mepClient.execute(true);
        originalInMsgCtx.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
    }

    private static org.apache.axis2.context.MessageContext cloneForSend(org.apache.axis2.context.MessageContext ori) throws AxisFault {
        org.apache.axis2.context.MessageContext newMC = MessageHelper.clonePartially(ori);
        newMC.setEnvelope(ori.getEnvelope());
        Axis2FlexibleMEPClient.removeAddressingHeaders(newMC);
        newMC.setProperty("TRANSPORT_HEADERS", ori.getProperty("TRANSPORT_HEADERS"));
        return newMC;
    }

    private static void copyRMOptions(org.apache.axis2.context.MessageContext oriContext, Options targetOptions) {
        Options oriOptions = oriContext.getOptions();
        if (oriOptions.getProperty("Sandesha2LastMessage") != null) {
            targetOptions.setProperty("Sandesha2LastMessage", oriOptions.getProperty("Sandesha2LastMessage"));
        }
        if (oriOptions.getProperty("Sandesha2RMSpecVersion") != null) {
            targetOptions.setProperty("Sandesha2RMSpecVersion", oriOptions.getProperty("Sandesha2RMSpecVersion"));
        }
        if (oriOptions.getProperty("Sandesha2SequenceKey") != null) {
            targetOptions.setProperty("Sandesha2SequenceKey", oriOptions.getProperty("Sandesha2SequenceKey"));
        }
        if (oriOptions.getProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID) != null) {
            targetOptions.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, oriOptions.getProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID));
        }
    }

    private static Policy getPolicy(MessageContext synCtx, String propertyKey) {
        Object property = synCtx.getEntry(propertyKey);
        if (property != null && property instanceof OMElement) {
            return PolicyEngine.getPolicy((OMElement)((OMElement)property));
        }
        Axis2FlexibleMEPClient.handleException("Cannot locate policy from the property : " + propertyKey);
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public static SOAPEnvelope removeAddressingHeaders(org.apache.axis2.context.MessageContext axisMsgCtx) {
        SOAPEnvelope env = axisMsgCtx.getEnvelope();
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader != null) {
            ArrayList addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            if (addressingHeaders != null && addressingHeaders.size() != 0) {
                Axis2FlexibleMEPClient.detachAddressingInformation(addressingHeaders);
            } else {
                addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://www.w3.org/2005/08/addressing");
                if (addressingHeaders != null && addressingHeaders.size() != 0) {
                    Axis2FlexibleMEPClient.detachAddressingInformation(addressingHeaders);
                }
            }
        }
        return env;
    }

    private static void detachAddressingInformation(ArrayList headerInformation) {
        for (Object o : headerInformation) {
            OMElement om;
            OMNamespace ns;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                headerBlock.detach();
                continue;
            }
            if (!(o instanceof OMElement) || (ns = (om = (OMElement)o).getNamespace()) == null || !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns.getNamespaceURI()) && !"http://www.w3.org/2005/08/addressing".equals(ns.getNamespaceURI())) continue;
            om.detach();
        }
    }
}

