/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.AddressEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointSerializer;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;

public class EndpointAbstractSerializer {
    public static EndpointSerializer getEndpointSerializer(Endpoint endpoint) {
        if (endpoint instanceof AddressEndpoint) {
            return new AddressEndpointSerializer();
        }
        if (endpoint instanceof WSDLEndpoint) {
            return new WSDLEndpointSerializer();
        }
        if (endpoint instanceof IndirectEndpoint) {
            return new IndirectEndpointSerializer();
        }
        if (endpoint instanceof LoadbalanceEndpoint) {
            return new LoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof SALoadbalanceEndpoint) {
            return new SALoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof FailoverEndpoint) {
            return new FailoverEndpointSerializer();
        }
        throw new SynapseException("Serializer for endpoint " + endpoint.getClass().toString() + " is not defined.");
    }
}

